/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.core.Profiler;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.ProfilerRecipeHandler;
import java.util.ArrayList;

public class GuiCraftingRecipe
extends GuiRecipe {
    public ArrayList<ICraftingHandler> currenthandlers;
    public static ArrayList<ICraftingHandler> craftinghandlers = new ArrayList();

    private GuiCraftingRecipe(awy prevgui, ArrayList<ICraftingHandler> handlers) {
        super(prevgui);
        this.currenthandlers = handlers;
    }

    public static void registerRecipeHandler(ICraftingHandler handler) {
        for (ICraftingHandler handler1 : craftinghandlers) {
            if (handler1.getClass() != handler.getClass()) continue;
            return;
        }
        craftinghandlers.add(handler);
    }

    public static boolean openRecipeGui(String outputId, Object ... results) {
        atv mc = NEIClientUtils.mc();
        if (!(mc.n instanceof awy)) {
            return false;
        }
        awy prevscreen = (awy)mc.n;
        Profiler profiler = ProfilerRecipeHandler.getProfiler();
        ArrayList<ICraftingHandler> handlers = new ArrayList<ICraftingHandler>();
        for (ICraftingHandler craftinghandler : craftinghandlers) {
            profiler.start(craftinghandler.getRecipeName());
            ICraftingHandler handler = craftinghandler.getRecipeHandler(outputId, results);
            if (handler.numRecipes() <= 0) continue;
            handlers.add(handler);
        }
        profiler.end();
        if (handlers.isEmpty()) {
            return false;
        }
        NEIClientUtils.overlayScreen(new GuiCraftingRecipe(prevscreen, handlers));
        return true;
    }

    @Override
    public ArrayList<? extends IRecipeHandler> getCurrentRecipeHandlers() {
        return this.currenthandlers;
    }
}

