/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.energy.prefab;

import cpw.mods.fml.common.FMLCommonHandler;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.info.Info;
import ic2.api.item.ElectricItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class BasicSource
extends TileEntity
implements IEnergySource {
    public final TileEntity parent;
    protected int capacity;
    protected int tier;
    protected double energyStored;
    protected boolean addedToEnet;

    public BasicSource(TileEntity parent1, int capacity1, int tier1) {
        int power = EnergyNet.instance.getPowerFromTier(tier1);
        this.parent = parent1;
        this.capacity = capacity1 < power ? power : capacity1;
        this.tier = tier1;
    }

    public void func_70316_g() {
        if (!this.addedToEnet) {
            this.onLoaded();
        }
    }

    public void onLoaded() {
        if (!this.addedToEnet && !FMLCommonHandler.instance().getEffectiveSide().isClient() && Info.isIc2Available()) {
            this.field_70331_k = this.parent.field_70331_k;
            this.field_70329_l = this.parent.field_70329_l;
            this.field_70330_m = this.parent.field_70330_m;
            this.field_70327_n = this.parent.field_70327_n;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnet = true;
        }
    }

    public void func_70313_j() {
        super.func_70313_j();
        this.onChunkUnload();
    }

    public void onChunkUnload() {
        if (this.addedToEnet && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnet = false;
        }
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        NBTTagCompound data = tag.func_74775_l("IC2BasicSource");
        this.energyStored = data.func_74769_h("energy");
    }

    public void func_70310_b(NBTTagCompound tag) {
        try {
            super.func_70310_b(tag);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        NBTTagCompound data = new NBTTagCompound();
        data.func_74780_a("energy", this.energyStored);
        tag.func_74782_a("IC2BasicSource", (NBTBase)data);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity1) {
        int power = EnergyNet.instance.getPowerFromTier(this.tier);
        if (capacity1 < power) {
            capacity1 = power;
        }
        this.capacity = capacity1;
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier1) {
        int power = EnergyNet.instance.getPowerFromTier(tier1);
        if (this.capacity < power) {
            this.capacity = power;
        }
        this.tier = tier1;
    }

    public double getEnergyStored() {
        return this.energyStored;
    }

    public void setEnergyStored(double amount) {
        this.energyStored = amount;
    }

    public double getFreeCapacity() {
        return (double)this.capacity - this.energyStored;
    }

    public double addEnergy(double amount) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return 0.0;
        }
        if (amount > (double)this.capacity - this.energyStored) {
            amount = (double)this.capacity - this.energyStored;
        }
        this.energyStored += amount;
        return amount;
    }

    public boolean charge(ItemStack stack) {
        if (stack == null || !Info.isIc2Available()) {
            return false;
        }
        int amount = ElectricItem.manager.charge(stack, (int)this.energyStored, this.tier, false, false);
        this.energyStored -= (double)amount;
        return amount > 0;
    }

    @Deprecated
    public void onUpdateEntity() {
        this.func_70316_g();
    }

    @Deprecated
    public void onInvalidate() {
        this.func_70313_j();
    }

    @Deprecated
    public void onOnChunkUnload() {
        this.onChunkUnload();
    }

    @Deprecated
    public void onReadFromNbt(NBTTagCompound tag) {
        this.func_70307_a(tag);
    }

    @Deprecated
    public void onWriteToNbt(NBTTagCompound tag) {
        this.func_70310_b(tag);
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    @Override
    public double getOfferedEnergy() {
        int power = EnergyNet.instance.getPowerFromTier(this.tier);
        if (this.energyStored >= (double)power) {
            return power;
        }
        return 0.0;
    }

    @Override
    public void drawEnergy(double amount) {
        this.energyStored -= amount;
    }
}

