/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.audio;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.audio.AudioManager;
import ic2.core.audio.AudioPosition;
import ic2.core.audio.AudioSource;
import ic2.core.audio.AudioSourceClient;
import ic2.core.audio.PositionSpec;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;

@SideOnly(value=Side.CLIENT)
public final class AudioManagerClient
extends AudioManager {
    public float fadingDistance = 16.0f;
    private boolean enabled = true;
    private int maxSourceCount = 32;
    private final int streamingSourceCount = 4;
    private SoundSystem soundSystem = null;
    private float masterVolume = 0.5f;
    private int nextId = 0;
    private final Map<WeakObject, List<AudioSource>> objectToAudioSourceMap = new HashMap<WeakObject, List<AudioSource>>();

    public AudioManagerClient() {
        this.defaultVolume = 1.2f;
    }

    @Override
    public void initialize(Configuration config) {
        if (config != null) {
            Property prop = config.get("general", "soundsEnabled", this.enabled);
            prop.comment = "Enable sounds";
            this.enabled = prop.getBoolean(this.enabled);
            prop = config.get("general", "soundSourceLimit", this.maxSourceCount);
            prop.comment = "Maximum number of audio sources, only change if you know what you're doing";
            this.maxSourceCount = prop.getInt(this.maxSourceCount);
            config.save();
        }
        if (this.maxSourceCount <= 6) {
            IC2.log.info("Audio source limit too low to enable IC2 sounds.");
            this.enabled = false;
        }
        if (!this.enabled) {
            IC2.log.info("Sounds disabled.");
            return;
        }
        if (this.maxSourceCount < 6) {
            this.enabled = false;
            return;
        }
        IC2.log.info("Using " + this.maxSourceCount + " audio sources.");
        SoundSystemConfig.setNumberStreamingChannels((int)4);
        SoundSystemConfig.setNumberNormalChannels((int)(this.maxSourceCount - 4));
    }

    @Override
    public void onTick() {
        if (!this.enabled || this.soundSystem == null) {
            return;
        }
        IC2.platform.profilerStartSection("UpdateMasterVolume");
        float configSoundVolume = Minecraft.func_71410_x().field_71474_y.field_74340_b;
        if (configSoundVolume != this.masterVolume) {
            this.masterVolume = configSoundVolume;
        }
        IC2.platform.profilerEndStartSection("UpdateSourceVolume");
        EntityPlayer player = IC2.platform.getPlayerInstance();
        Vector<WeakObject> audioSourceObjectsToRemove = new Vector<WeakObject>();
        if (player == null) {
            audioSourceObjectsToRemove.addAll(this.objectToAudioSourceMap.keySet());
        } else {
            PriorityQueue<AudioSource> validAudioSources = new PriorityQueue<AudioSource>();
            for (Map.Entry<WeakObject, List<AudioSource>> entry : this.objectToAudioSourceMap.entrySet()) {
                if (entry.getKey().isEnqueued()) {
                    audioSourceObjectsToRemove.add(entry.getKey());
                    continue;
                }
                for (AudioSource audioSource : entry.getValue()) {
                    audioSource.updateVolume(player);
                    if (!(audioSource.getRealVolume() > 0.0f)) continue;
                    validAudioSources.add(audioSource);
                }
            }
            IC2.platform.profilerEndStartSection("Culling");
            int i = 0;
            while (!validAudioSources.isEmpty()) {
                if (i < this.maxSourceCount) {
                    ((AudioSource)validAudioSources.poll()).activate();
                } else {
                    ((AudioSource)validAudioSources.poll()).cull();
                }
                ++i;
            }
        }
        for (WeakObject obj : audioSourceObjectsToRemove) {
            this.removeSources(obj);
        }
        IC2.platform.profilerEndSection();
    }

    @Override
    public AudioSource createSource(Object obj, String initialSoundFile) {
        return this.createSource(obj, PositionSpec.Center, initialSoundFile, false, false, this.defaultVolume);
    }

    @Override
    public AudioSource createSource(Object obj, PositionSpec positionSpec, String initialSoundFile, boolean loop, boolean priorized, float volume) {
        if (!this.enabled) {
            return null;
        }
        if (this.soundSystem == null) {
            this.getSoundSystem();
        }
        if (this.soundSystem == null) {
            return null;
        }
        String sourceName = AudioManagerClient.getSourceName(this.nextId);
        ++this.nextId;
        AudioSourceClient audioSource = new AudioSourceClient(this.soundSystem, sourceName, obj, positionSpec, initialSoundFile, loop, priorized, volume);
        WeakObject key = new WeakObject(obj);
        if (!this.objectToAudioSourceMap.containsKey(key)) {
            this.objectToAudioSourceMap.put(key, new LinkedList());
        }
        this.objectToAudioSourceMap.get(key).add(audioSource);
        return audioSource;
    }

    @Override
    public void removeSources(Object obj) {
        if (this.soundSystem == null) {
            return;
        }
        WeakObject key = obj instanceof WeakObject ? (WeakObject)obj : new WeakObject(obj);
        if (!this.objectToAudioSourceMap.containsKey(key)) {
            return;
        }
        for (AudioSource audioSource : this.objectToAudioSourceMap.get(key)) {
            audioSource.remove();
        }
        this.objectToAudioSourceMap.remove(key);
    }

    @Override
    public void playOnce(Object obj, String soundFile) {
        this.playOnce(obj, PositionSpec.Center, soundFile, false, this.defaultVolume);
    }

    @Override
    public void playOnce(Object obj, PositionSpec positionSpec, String soundFile, boolean priorized, float volume) {
        if (!this.enabled) {
            return;
        }
        if (this.soundSystem == null) {
            this.getSoundSystem();
        }
        if (this.soundSystem == null) {
            return;
        }
        AudioPosition position = AudioPosition.getFrom(obj, positionSpec);
        if (position == null) {
            return;
        }
        URL url = AudioSource.class.getClassLoader().getResource("ic2/sounds/" + soundFile);
        if (url == null) {
            IC2.log.warning("Invalid sound file: " + soundFile);
            return;
        }
        String sourceName = this.soundSystem.quickPlay(priorized, url, soundFile, false, position.x, position.y, position.z, 2, this.fadingDistance * Math.max(volume, 1.0f));
        this.soundSystem.setVolume(sourceName, this.masterVolume * Math.min(volume, 1.0f));
    }

    @Override
    public float getMasterVolume() {
        return this.masterVolume;
    }

    private void getSoundSystem() {
        this.soundSystem = Minecraft.func_71410_x().field_71416_A.field_77381_a;
    }

    private static String getSourceName(int id) {
        return "asm_snd" + id;
    }

    public static class WeakObject
    extends WeakReference<Object> {
        public WeakObject(Object referent) {
            super(referent);
        }

        public boolean equals(Object object) {
            if (object instanceof WeakObject) {
                return ((WeakObject)object).get() == this.get();
            }
            return this.get() == object;
        }

        public int hashCode() {
            Object object = this.get();
            if (object == null) {
                return 0;
            }
            return object.hashCode();
        }
    }
}

