/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart;

import codechicken.lib.vec.Rotation;
import codechicken.multipart.IFaceRedstonePart;
import codechicken.multipart.IMaskedRedstonePart;
import codechicken.multipart.IRedstoneConnector;
import codechicken.multipart.IRedstoneConnectorBlock;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.IRedstoneTile;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;

public final class RedstoneInteractions$ {
    public static final RedstoneInteractions$ MODULE$;
    private final int[] vanillaSideMap;
    private final int[] sideVanillaMap;
    private final boolean[] fullVanillaBlocks;

    static {
        new RedstoneInteractions$();
    }

    public int[] vanillaSideMap() {
        return this.vanillaSideMap;
    }

    public int[] sideVanillaMap() {
        return this.sideVanillaMap;
    }

    public boolean[] fullVanillaBlocks() {
        return this.fullVanillaBlocks;
    }

    public int getPowerTo(TMultiPart p, int side) {
        TileMultipart tile = p.tile();
        return this.getPowerTo(tile.k, tile.l, tile.m, tile.n, side, ((IRedstoneTile)((Object)tile)).openConnections(side) & this.connectionMask(p, side));
    }

    public int getPowerTo(abw world, int x, int y, int z, int side, int mask) {
        return this.getPower(world, x + s.b[side], y + s.c[side], z + s.d[side], side ^ 1, mask);
    }

    public int getPower(abw world, int x, int y, int z, int side, int mask) {
        asp tile = world.r(x, y, z);
        if (tile instanceof IRedstoneConnector) {
            return ((IRedstoneConnector)tile).weakPowerLevel(side, mask);
        }
        aqz block = aqz.s[world.a(x, y, z)];
        if (block == null) {
            return 0;
        }
        if (block instanceof IRedstoneConnectorBlock) {
            return ((IRedstoneConnectorBlock)block).weakPowerLevel((acf)world, x, y, z, side, mask);
        }
        int vmask = this.vanillaConnectionMask(block, (acf)world, x, y, z, side, true);
        if ((vmask & mask) > 0) {
            int m = world.l(x, y, z, side ^ 1);
            if (m < 15) {
                aqz aqz2 = block;
                aqb aqb2 = aqz.aA;
                if (!(aqz2 != null ? !aqz2.equals(aqb2) : aqb2 != null)) {
                    m = Math.max(m, world.h(x, y, z));
                }
            }
            return m;
        }
        return 0;
    }

    public int vanillaToSide(int vside) {
        return this.sideVanillaMap()[vside + 1];
    }

    public int otherConnectionMask(acf world, int x, int y, int z, int side, boolean power) {
        return this.getConnectionMask(world, x + s.b[side], y + s.c[side], z + s.d[side], side ^ 1, power);
    }

    public int connectionMask(TMultiPart p, int side) {
        if (p instanceof IRedstonePart && ((IRedstonePart)((Object)p)).canConnectRedstone(side)) {
            if (p instanceof IFaceRedstonePart) {
                int fside = ((IFaceRedstonePart)((Object)p)).getFace();
                if ((side & 6) == (fside & 6)) {
                    return 16;
                }
                return 1 << Rotation.rotationTo((int)(side & 6), (int)fside);
            }
            if (p instanceof IMaskedRedstonePart) {
                return ((IMaskedRedstonePart)((Object)p)).getConnectionMask(side);
            }
            return 31;
        }
        return 0;
    }

    public int getConnectionMask(acf world, int x, int y, int z, int side, boolean power) {
        asp tile = world.r(x, y, z);
        if (tile instanceof IRedstoneConnector) {
            return ((IRedstoneConnector)tile).getConnectionMask(side);
        }
        aqz block = aqz.s[world.a(x, y, z)];
        if (block == null) {
            return 0;
        }
        if (block instanceof IRedstoneConnectorBlock) {
            return ((IRedstoneConnectorBlock)block).getConnectionMask(world, x, y, z, side);
        }
        return this.vanillaConnectionMask(block, world, x, y, z, side, power);
    }

    public int vanillaConnectionMask(aqz block, acf world, int x, int y, int z, int side, boolean power) {
        int vside;
        block14: {
            int meta;
            block13: {
                block12: {
                    block11: {
                        if (this.fullVanillaBlocks()[block.cF]) {
                            return 31;
                        }
                        if (side == 0) {
                            return power ? 31 : 0;
                        }
                        aqz aqz2 = block;
                        aqb aqb2 = aqz.aA;
                        if (!(aqz2 == null ? aqb2 != null : !aqz2.equals(aqb2))) break block11;
                        aqz aqz3 = block;
                        anp anp2 = aqz.cr;
                        if (!(aqz3 == null ? anp2 != null : !aqz3.equals(anp2))) break block11;
                        aqz aqz4 = block;
                        anp anp3 = aqz.cq;
                        if (aqz4 != null ? !aqz4.equals(anp3) : anp3 != null) break block12;
                    }
                    if (side != 0) {
                        return power ? 31 : 4;
                    }
                    return 0;
                }
                vside = this.vanillaSideMap()[side];
                aqz aqz5 = block;
                aqf aqf2 = aqz.bn;
                if (!(aqz5 == null ? aqf2 != null : !aqz5.equals(aqf2))) break block13;
                aqz aqz6 = block;
                aqf aqf3 = aqz.bm;
                if (aqz6 != null ? !aqz6.equals(aqf3) : aqf3 != null) break block14;
            }
            if (vside == ((meta = world.h(x, y, z)) & 3) || vside == r.f[meta & 3]) {
                return power ? 31 : 4;
            }
            return 0;
        }
        if (power || block.canConnectRedstone(world, x, y, z, vside)) {
            return 31;
        }
        return 0;
    }

    private RedstoneInteractions$() {
        MODULE$ = this;
        this.vanillaSideMap = new int[]{-2, -1, 0, 2, 3, 1};
        this.sideVanillaMap = new int[]{1, 2, 5, 3, 4};
        this.fullVanillaBlocks = (boolean[])Array$.MODULE$.ofDim(aqz.s.length, ClassTag$.MODULE$.Boolean());
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new aqz[]{aqz.aV, aqz.aU, aqz.aO, aqz.aW, aqz.ck, aqz.ct}))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(aqz b) {
                RedstoneInteractions$.MODULE$.fullVanillaBlocks()[b.cF] = true;
            }
        });
    }
}

