/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator;

import bspkrs.treecapitator.TCSettings;
import bspkrs.treecapitator.TreeDefinition;
import bspkrs.util.BlockID;
import bspkrs.util.ConfigCategory;
import bspkrs.util.Configuration;
import bspkrs.util.HashCodeUtil;
import bspkrs.util.ListUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConfigTreeDefinition
extends TreeDefinition {
    protected String logKeys;
    protected String leafKeys;

    public ConfigTreeDefinition() {
        this.logKeys = ListUtils.getListAsDelimitedString((List)this.logBlocks, (String)"; ");
        this.leafKeys = ListUtils.getListAsDelimitedString((List)this.leafBlocks, (String)"; ");
    }

    public ConfigTreeDefinition(List<BlockID> logs, List<BlockID> leaves) {
        super(logs, leaves);
        this.logKeys = ListUtils.getListAsDelimitedString((List)this.logBlocks, (String)"; ");
        this.leafKeys = ListUtils.getListAsDelimitedString((List)this.leafBlocks, (String)"; ");
    }

    public ConfigTreeDefinition(String configLogs, String configLeaves) {
        this();
        this.logKeys = configLogs;
        this.leafKeys = configLeaves;
    }

    public ConfigTreeDefinition(Configuration config, String category) {
        this();
        this.readFromConfiguration(config, category);
    }

    public ConfigTreeDefinition(by treeDefNBT) {
        this();
        this.readFromNBT(treeDefNBT);
    }

    @Override
    public ConfigTreeDefinition readFromNBT(by treeDefNBT) {
        super.readFromNBT(treeDefNBT);
        this.logKeys = treeDefNBT.b("logConfigKeys") ? treeDefNBT.i("logConfigKeys") : ListUtils.getListAsDelimitedString((List)this.logBlocks, (String)"; ");
        this.leafKeys = treeDefNBT.b("leafConfigKeys") ? treeDefNBT.i("leafConfigKeys") : ListUtils.getListAsDelimitedString((List)this.leafBlocks, (String)"; ");
        return this;
    }

    @Override
    public void writeToNBT(by treeDefNBT) {
        super.writeToNBT(treeDefNBT);
        treeDefNBT.a("logConfigKeys", this.logKeys);
        treeDefNBT.a("leafConfigKeys", this.leafKeys);
    }

    public ConfigTreeDefinition readFromConfiguration(Configuration config, String category) {
        ConfigCategory cc = config.getCategory(category);
        if (cc.containsKey("allowSmartTreeDetection")) {
            this.onlyDestroyUpwards = cc.get("allowSmartTreeDetection").getBoolean(TCSettings.allowSmartTreeDetection);
        }
        if (cc.containsKey("onlyDestroyUpwards")) {
            this.onlyDestroyUpwards = cc.get("onlyDestroyUpwards").getBoolean(TCSettings.onlyDestroyUpwards);
        }
        if (cc.containsKey("requireLeafDecayCheck")) {
            this.requireLeafDecayCheck = cc.get("requireLeafDecayCheck").getBoolean(TCSettings.requireLeafDecayCheck);
        }
        if (cc.containsKey("maxHorLogBreakDist")) {
            this.maxHorLogBreakDist = cc.get("maxHorLogBreakDist").getInt(TCSettings.maxHorLogBreakDist);
        }
        if (cc.containsKey("maxVerLogBreakDist")) {
            this.maxVerLogBreakDist = cc.get("maxVerLogBreakDist").getInt(TCSettings.maxVerLogBreakDist);
        }
        if (cc.containsKey("maxHorLeafBreakDist")) {
            this.maxHorLeafBreakDist = cc.get("maxHorLeafBreakDist").getInt(TCSettings.maxHorLeafBreakDist);
        }
        if (cc.containsKey("maxLeafIDDist")) {
            this.maxLeafIDDist = cc.get("maxLeafIDDist").getInt(TCSettings.maxLeafIDDist);
        }
        if (cc.containsKey("minLeavesToID")) {
            this.minLeavesToID = cc.get("minLeavesToID").getInt();
        }
        if (cc.containsKey("breakSpeedModifier")) {
            this.breakSpeedModifier = (float)cc.get("breakSpeedModifier").getDouble((double)TCSettings.breakSpeedModifier);
        }
        if (cc.containsKey("useAdvancedTopLogLogic")) {
            this.useAdvancedTopLogLogic = cc.get("useAdvancedTopLogLogic").getBoolean(TCSettings.useAdvancedTopLogLogic);
        }
        this.logKeys = cc.get("logConfigKeys").getString();
        if (cc.containsKey("leafConfigKeys")) {
            this.leafKeys = cc.get("leafConfigKeys").getString();
        }
        return this;
    }

    public void writeToConfiguration(Configuration config, String category) {
        if (this.allowSmartTreeDetection != TCSettings.allowSmartTreeDetection) {
            config.get(category, "allowSmartTreeDetection", TCSettings.allowSmartTreeDetection, "Optional").set(this.allowSmartTreeDetection);
        }
        if (this.onlyDestroyUpwards != TCSettings.onlyDestroyUpwards) {
            config.get(category, "onlyDestroyUpwards", TCSettings.onlyDestroyUpwards, "Optional").set(this.onlyDestroyUpwards);
        }
        if (this.requireLeafDecayCheck != TCSettings.requireLeafDecayCheck) {
            config.get(category, "requireLeafDecayCheck", TCSettings.requireLeafDecayCheck, "Optional").set(this.requireLeafDecayCheck);
        }
        if (this.maxHorLogBreakDist != TCSettings.maxHorLogBreakDist) {
            config.get(category, "maxHorLogBreakDist", TCSettings.maxHorLogBreakDist, "Optional").set(this.maxHorLogBreakDist);
        }
        if (this.maxVerLogBreakDist != TCSettings.maxVerLogBreakDist) {
            config.get(category, "maxVerLogBreakDist", TCSettings.maxVerLogBreakDist, "Optional").set(this.maxVerLogBreakDist);
        }
        if (this.maxHorLeafBreakDist != TCSettings.maxHorLeafBreakDist) {
            config.get(category, "maxHorLeafBreakDist", TCSettings.maxHorLeafBreakDist, "Optional").set(this.maxHorLeafBreakDist);
        }
        if (this.maxLeafIDDist != TCSettings.maxLeafIDDist) {
            config.get(category, "maxLeafIDDist", TCSettings.maxLeafIDDist, "Optional").set(this.maxLeafIDDist);
        }
        if (this.minLeavesToID != TCSettings.minLeavesToID) {
            config.get(category, "minLeavesToID", TCSettings.minLeavesToID, "Optional").set(this.minLeavesToID);
        }
        if (this.breakSpeedModifier != TCSettings.breakSpeedModifier) {
            config.get(category, "breakSpeedModifier", (double)TCSettings.breakSpeedModifier, "Optional").set((double)this.breakSpeedModifier);
        }
        if (this.useAdvancedTopLogLogic != TCSettings.useAdvancedTopLogLogic) {
            config.get(category, "useAdvancedTopLogLogic", TCSettings.useAdvancedTopLogLogic, "Optional").set(this.useAdvancedTopLogLogic);
        }
        config.get(category, "logConfigKeys", this.logKeys);
        config.get(category, "leafConfigKeys", this.leafKeys);
    }

    public TreeDefinition getTagsReplacedTreeDef(Map<String, String> tagMap) {
        BlockID blockID;
        this.logBlocks = new ArrayList();
        this.leafBlocks = new ArrayList();
        String rLogs = this.logKeys;
        String rLeaves = this.leafKeys;
        for (Map.Entry<String, String> e : tagMap.entrySet()) {
            rLogs = rLogs.replace(e.getKey(), e.getValue());
            rLeaves = rLeaves.replace(e.getKey(), e.getValue());
        }
        for (String log : rLogs.split(";")) {
            blockID = new BlockID(log, ",", 0);
            if (blockID.id <= 0) continue;
            super.addLogID(blockID);
        }
        for (String leaf : rLeaves.split(";")) {
            blockID = new BlockID(leaf, ",", 0);
            if (blockID.id <= 0) continue;
            super.addLeafID(blockID);
        }
        return this;
    }

    @Override
    public ConfigTreeDefinition addLogID(BlockID blockID) {
        ConfigTreeDefinition r = (ConfigTreeDefinition)super.addLogID(blockID);
        this.logKeys = ListUtils.getListAsDelimitedString((List)r.logBlocks, (String)"; ");
        return r;
    }

    @Override
    public ConfigTreeDefinition addLeafID(BlockID blockID) {
        ConfigTreeDefinition r = (ConfigTreeDefinition)super.addLeafID(blockID);
        this.leafKeys = ListUtils.getListAsDelimitedString((List)r.leafBlocks, (String)"; ");
        return r;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ConfigTreeDefinition)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ConfigTreeDefinition td = (ConfigTreeDefinition)o;
        return td.logBlocks.equals(this.logBlocks) && td.leafBlocks.equals(this.leafBlocks);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = HashCodeUtil.hash((int)result, (Object)this.logKeys);
        result = HashCodeUtil.hash((int)result, (Object)this.leafKeys);
        return result;
    }

    public String getConfigLogList() {
        return this.logKeys;
    }

    public String getConfigLeafList() {
        return this.leafKeys;
    }

    @Override
    public ConfigTreeDefinition setAllowSmartTreeDetection(boolean allowSmartTreeDetection) {
        return (ConfigTreeDefinition)super.setAllowSmartTreeDetection(allowSmartTreeDetection);
    }

    @Override
    public ConfigTreeDefinition setOnlyDestroyUpwards(boolean onlyDestroyUpwards) {
        return (ConfigTreeDefinition)super.setOnlyDestroyUpwards(onlyDestroyUpwards);
    }

    @Override
    public ConfigTreeDefinition setRequireLeafDecayCheck(boolean requireLeafDecayCheck) {
        return (ConfigTreeDefinition)super.setRequireLeafDecayCheck(requireLeafDecayCheck);
    }

    @Override
    public ConfigTreeDefinition setMaxHorLogBreakDist(int maxHorLogBreakDist) {
        return (ConfigTreeDefinition)super.setMaxHorLogBreakDist(maxHorLogBreakDist);
    }

    @Override
    public ConfigTreeDefinition setMaxVerLogBreakDist(int maxVerLogBreakDist) {
        return (ConfigTreeDefinition)super.setMaxVerLogBreakDist(maxVerLogBreakDist);
    }

    @Override
    public ConfigTreeDefinition setMaxLeafIDDist(int maxLeafIDDist) {
        return (ConfigTreeDefinition)super.setMaxLeafIDDist(maxLeafIDDist);
    }

    @Override
    public ConfigTreeDefinition setMaxHorLeafBreakDist(int maxHorLeafBreakDist) {
        return (ConfigTreeDefinition)super.setMaxHorLeafBreakDist(maxHorLeafBreakDist);
    }

    @Override
    public ConfigTreeDefinition setMinLeavesToID(int minLeavesToID) {
        return (ConfigTreeDefinition)super.setMinLeavesToID(minLeavesToID);
    }

    @Override
    public ConfigTreeDefinition setBreakSpeedModifier(float breakSpeedModifier) {
        return (ConfigTreeDefinition)super.setBreakSpeedModifier(breakSpeedModifier);
    }

    @Override
    public ConfigTreeDefinition setUseAdvancedTopLogLogic(boolean useAdvancedTopLogLogic) {
        return (ConfigTreeDefinition)super.setUseAdvancedTopLogLogic(useAdvancedTopLogLogic);
    }
}

