/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.fml;

import bspkrs.bspkrscore.fml.bspkrsCoreMod;
import bspkrs.treecapitator.RegistryNBTManager;
import bspkrs.treecapitator.TCLog;
import bspkrs.treecapitator.TCSettings;
import bspkrs.treecapitator.ToolRegistry;
import bspkrs.treecapitator.TreeDefinition;
import bspkrs.treecapitator.TreeRegistry;
import bspkrs.treecapitator.Treecapitator;
import bspkrs.treecapitator.fml.CommonProxy;
import bspkrs.treecapitator.fml.ConnectionHandler;
import bspkrs.treecapitator.fml.ForgeEventHandler;
import bspkrs.treecapitator.fml.IDResolverMappingList;
import bspkrs.treecapitator.fml.ModConfigRegistry;
import bspkrs.treecapitator.fml.OreDictionaryHandler;
import bspkrs.treecapitator.fml.TCConfigHandler;
import bspkrs.treecapitator.fml.ThirdPartyModConfig;
import bspkrs.treecapitator.fml.TreeCapitatorClient;
import bspkrs.treecapitator.fml.TreeCapitatorServer;
import bspkrs.util.BlockID;
import bspkrs.util.CommonUtils;
import bspkrs.util.Configuration;
import bspkrs.util.Coord;
import bspkrs.util.ModVersionChecker;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import java.io.File;
import net.minecraftforge.common.MinecraftForge;

@Mod(name="TreeCapitator", modid="TreeCapitator", version="Forge 1.6.4.r06", dependencies="required-after:bspkrsCore", useMetadata=true)
@NetworkMod(clientSideRequired=false, serverSideRequired=false, clientPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"TreeCapitator"}, packetHandler=TreeCapitatorClient.class), serverPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"TreeCapitator"}, packetHandler=TreeCapitatorServer.class), connectionHandler=ConnectionHandler.class)
public class TreeCapitatorMod {
    public static ModVersionChecker versionChecker;
    private final String versionURL = "http://dl.dropboxusercontent.com/u/20748481/Minecraft/1.6.4/treeCapitatorForge.version";
    private final String mcfTopic = "http://www.minecraftforum.net/topic/1009577-";
    public static boolean isCoreModLoaded;
    private RegistryNBTManager nbtManager;
    public Configuration config;
    @Mod.Metadata(value="TreeCapitator")
    public static ModMetadata metadata;
    @SidedProxy(clientSide="bspkrs.treecapitator.fml.ClientProxy", serverSide="bspkrs.treecapitator.fml.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="TreeCapitator")
    public static TreeCapitatorMod instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        metadata = event.getModMetadata();
        File file = event.getSuggestedConfigurationFile();
        if (!CommonUtils.isObfuscatedEnv()) {
            // empty if block
        }
        IDResolverMappingList.instance();
        TCConfigHandler.setInstance(file);
        if (bspkrsCoreMod.instance.allowUpdateCheck) {
            versionChecker = new ModVersionChecker(TreeCapitatorMod.metadata.name, TreeCapitatorMod.metadata.version, "http://dl.dropboxusercontent.com/u/20748481/Minecraft/1.6.4/treeCapitatorForge.version", "http://www.minecraftforum.net/topic/1009577-");
            versionChecker.checkVersionWithLogging();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandler());
        proxy.onLoad();
    }

    @Mod.EventHandler
    public void processIMCMessages(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages().asList()) {
            if (msg.isNBTMessage()) {
                TCLog.info("Received IMC message from mod %s.", msg.getSender());
                ModConfigRegistry.instance().registerIMCModConfig(new ThirdPartyModConfig(msg.getNBTValue()));
                continue;
            }
            TCLog.warning("Mod %s send an IMC message, but it is not an NBT object message. The message will be ignored.", msg.getSender());
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ToolRegistry.instance().readBlacklistFromDelimitedString(TCSettings.itemIDBlacklist);
        ModConfigRegistry.instance().applyPrioritizedModConfigs();
        OreDictionaryHandler.instance().generateAndRegisterOreDictionaryTreeDefinitions();
        if (Loader.isModLoaded((String)TCSettings.multiMineModID)) {
            String s = TreeRegistry.instance().getMultiMineExclusionString();
            TCLog.info("For Multi-Mine compatibility you should put this list in the S:\"Excluded Block IDs\" config setting in AS_MultiMine.cfg: \"%s\"", s);
            TCConfigHandler.instance().config.get("tree_and_mod_configs", "Excluded Block IDs", "", "For Multi-Mine compatibility you should put this list in the S:\"Excluded Block IDs\" config setting in AS_MultiMine.cfg").set(s);
            TCConfigHandler.instance().config.save();
        }
        TreeRegistry.instance().readBlacklistFromDelimitedString(TCSettings.blockIDBlacklist);
        this.nbtManager();
    }

    public void onBlockHarvested(abw world, int x, int y, int z, aqz block, int metadata, uf entityPlayer) {
        if (proxy.isEnabled() && !world.I) {
            BlockID blockID = new BlockID(block, metadata);
            if (TreeRegistry.instance().isRegistered(blockID)) {
                Coord blockPos = new Coord(x, y, z);
                if (TreeRegistry.instance().trackTreeChopEventAt(blockPos)) {
                    TCLog.debug("BlockID " + blockID + " is a log.", new Object[0]);
                    if (Treecapitator.isBreakingEnabled(entityPlayer) && Treecapitator.isBreakingPossible(world, entityPlayer, true)) {
                        TreeDefinition treeDef = TreeRegistry.instance().get(blockID);
                        if (treeDef != null) {
                            Treecapitator breaker = new Treecapitator(entityPlayer, treeDef);
                            breaker.onBlockHarvested(world, x, y, z, metadata, entityPlayer);
                        } else {
                            TCLog.severe("TreeRegistry reported block ID %s is a log, but TreeDefinition lookup failed! Please report this to bspkrs (include a copy of this log file and your config).", blockID);
                        }
                    } else {
                        TCLog.debug("Chopping disabled due to player state or gamemode.", new Object[0]);
                    }
                    TreeRegistry.instance().endTreeChopEventAt(blockPos);
                } else {
                    TCLog.debug("Previous chopping event detected for block @%s", blockPos.toString());
                }
            }
        }
    }

    public static boolean isItemInWorldManagerReplaced(jv player) {
        if (player != null) {
            return !player.c.getClass().getSimpleName().equals(jw.class.getSimpleName());
        }
        return false;
    }

    public RegistryNBTManager nbtManager() {
        if (this.nbtManager == null) {
            this.nbtManager = new RegistryNBTManager();
        }
        return this.nbtManager;
    }

    static {
        isCoreModLoaded = false;
    }
}

