/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.handlers;

import com.google.common.base.Optional;
import extrabiomes.Extrabiomes;
import extrabiomes.api.Api;
import extrabiomes.api.events.GetBiomeIDEvent;
import extrabiomes.helpers.BiomeHelper;
import extrabiomes.helpers.LogHelper;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.module.summa.worldgen.LegendOakGenerator;
import extrabiomes.module.summa.worldgen.MarshGenerator;
import extrabiomes.module.summa.worldgen.MountainDesertGenerator;
import extrabiomes.module.summa.worldgen.MountainRidgeGenerator;
import extrabiomes.module.summa.worldgen.VanillaFloraGenerator;
import java.util.Locale;
import java.util.Set;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.ForgeSubscribe;

public enum BiomeHandler {
    INSTANCE;


    public static void enableBiomes() {
        Set<acg> worldTypes = BiomeHelper.discoverWorldTypes();
        for (BiomeSettings setting : BiomeSettings.values()) {
            Optional<? extends acq> biome = setting.getBiome();
            if (!setting.isVanilla()) {
                if (setting.isEnabled() && biome.isPresent()) {
                    BiomeHelper.enableBiome(worldTypes, (acq)biome.get());
                } else {
                    LogHelper.fine("Custom biome %s disabled.", setting.toString());
                }
            } else if (!setting.isEnabled()) {
                Extrabiomes.proxy.removeBiome(BiomeHelper.settingToBiomeGenBase(setting));
                LogHelper.fine("Vanilla biome %s disabled.", biome.toString());
            }
            if (!setting.isEnabled() || !setting.allowVillages() || !biome.isPresent()) continue;
            BiomeManager.addVillageBiome((acq)((acq)biome.get()), (boolean)true);
            LogHelper.fine("Village spawning enabled for custom biome %s.", setting.toString());
        }
    }

    public static void init() throws Exception {
        for (BiomeSettings biome : BiomeSettings.values()) {
            if (biome.getID() <= 0 || !biome.isEnabled()) continue;
            BiomeHelper.createBiome(biome);
        }
        Api.getExtrabiomesXLEventBus().register((Object)INSTANCE);
    }

    public static void registerWorldGenerators() {
        if (BiomeSettings.MARSH.isEnabled() && BiomeSettings.MARSH.getBiome().isPresent()) {
            Extrabiomes.proxy.registerWorldGenerator(new MarshGenerator());
        }
        if (BiomeSettings.MOUNTAINDESERT.isEnabled() && BiomeSettings.MOUNTAINDESERT.getBiome().isPresent()) {
            Extrabiomes.proxy.registerWorldGenerator(new MountainDesertGenerator());
        }
        if (BiomeSettings.MOUNTAINRIDGE.isEnabled() && BiomeSettings.MOUNTAINRIDGE.getBiome().isPresent()) {
            Extrabiomes.proxy.registerWorldGenerator(new MountainRidgeGenerator());
        }
        Extrabiomes.proxy.registerWorldGenerator(new VanillaFloraGenerator());
        Extrabiomes.proxy.registerWorldGenerator(new LegendOakGenerator());
    }

    @ForgeSubscribe
    public void handleBiomeIDRequestsFromAPI(GetBiomeIDEvent event) {
        Optional settings = Optional.fromNullable((Object)((Object)BiomeSettings.valueOf(event.targetBiome.toUpperCase(Locale.ENGLISH))));
        if (settings.isPresent()) {
            event.biomeID = ((BiomeSettings)((Object)settings.get())).getID();
        }
    }
}

