/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.module.summa.worldgen.WorldGenOasis;
import java.util.Random;

public class MountainRidgeGenerator
implements IWorldGenerator {
    private static final afe oasisGen = new WorldGenOasis();
    private static final afe silverfishGen = new afq(aqz.bq.cF, 8);

    public void generate(Random random, int chunkX, int chunkZ, abw world, ado chunkGenerator, ado chunkProvider) {
        acq biome = world.a(chunkX <<= 4, chunkZ <<= 4);
        if (BiomeSettings.MOUNTAINRIDGE.getBiome().isPresent() && biome == BiomeSettings.MOUNTAINRIDGE.getBiome().get()) {
            this.trimPondsInGrass(random, chunkX, chunkZ, world);
            this.generateEmeraldOre(random, chunkX, chunkZ, world);
        }
    }

    private void generateEmeraldOre(Random rand, int x, int z2, abw world) {
        int z1;
        int y1;
        int x1;
        int i;
        int veins = 3 + rand.nextInt(6);
        for (i = 0; i < veins; ++i) {
            x1 = x + rand.nextInt(16);
            int id = world.a(x1, y1 = rand.nextInt(28) + 4, z1 = z2 + rand.nextInt(16));
            if (id == 0 || !aqz.s[id].isGenMineableReplaceable(world, x1, y1, z1, aqz.y.cF)) continue;
            world.c(x1, y1, z1, aqz.bW.cF);
        }
        for (i = 0; i < 7; ++i) {
            x1 = x + rand.nextInt(16);
            y1 = rand.nextInt(64);
            z1 = z2 + rand.nextInt(16);
            silverfishGen.a(world, rand, x1, y1, z1);
        }
    }

    private void trimPondsInGrass(Random rand, int x, int z2, abw world) {
        for (int i = 0; i < 1000; ++i) {
            int x1 = x + rand.nextInt(16) + 8;
            int z1 = z2 + rand.nextInt(16) + 8;
            int y1 = world.i(x1, z1);
            oasisGen.a(world, rand, x1, y1, z1);
        }
    }
}

