/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import extrabiomes.lib.Element;
import extrabiomes.module.summa.TreeSoilRegistry;
import java.util.Random;

public class WorldGenFirTree
extends afe {
    private static long lastSeed = 0L;

    public WorldGenFirTree(boolean par1) {
        super(par1);
    }

    public boolean a(abw world, Random rand, int x, int y, int z2) {
        lastSeed = rand.nextLong();
        return this.generateTree(world, new Random(lastSeed), x, y, z2);
    }

    public boolean generate(abw world, long seed, int x, int y, int z2) {
        lastSeed = seed;
        return this.generateTree(world, new Random(seed), x, y, z2);
    }

    private boolean generateTree(abw world, Random rand, int x, int y, int z2) {
        int below = world.a(x, y - 1, z2);
        int height = rand.nextInt(8) + 24;
        if (!TreeSoilRegistry.isValidSoil(below) || y >= 256 - height - 1) {
            return false;
        }
        if (y < 1 || y + height + 1 > 256) {
            return false;
        }
        int j = 1 + rand.nextInt(12);
        int l = 2 + rand.nextInt(6);
        for (int i1 = y; i1 <= y + 1 + height; ++i1) {
            if (i1 < 0 || i1 >= 256) {
                return false;
            }
            int k1 = 1;
            k1 = i1 - y < j ? 0 : l;
            for (int x1 = x - k1; x1 <= x + k1; ++x1) {
                for (int z1 = z2 - k1; z1 <= z2 + k1; ++z1) {
                    int id = world.a(x1, i1, z1);
                    if (aqz.s[id] == null || aqz.s[id].isLeaves(world, x1, i1, z1)) continue;
                    return false;
                }
            }
        }
        world.c(x, y - 1, z2, aqz.A.cF);
        int l1 = rand.nextInt(2);
        int j2 = 1;
        boolean flag1 = false;
        for (int i3 = 0; i3 <= height - j; ++i3) {
            int k3 = y + height - i3;
            for (int i4 = x - l1; i4 <= x + l1; ++i4) {
                int k4 = i4 - x;
                for (int l4 = z2 - l1; l4 <= z2 + l1; ++l4) {
                    int i5 = l4 - z2;
                    aqz block = aqz.s[world.a(i4, k3, l4)];
                    if (Math.abs(k4) == l1 && Math.abs(i5) == l1 && l1 > 0 || block != null && !block.canBeReplacedByLeaves(world, i4, k3, l4)) continue;
                    this.a(world, i4, k3, l4, TreeBlock.LEAVES.getID(), TreeBlock.LEAVES.getMetadata());
                }
            }
            if (l1 >= j2) {
                l1 = flag1 ? 1 : 0;
                flag1 = true;
                if (++j2 <= l) continue;
                j2 = l;
                continue;
            }
            ++l1;
        }
        int j3 = rand.nextInt(3);
        for (int l3 = 0; l3 < height - j3; ++l3) {
            int id = world.a(x, y + l3, z2);
            if (aqz.s[id] != null && !aqz.s[id].isLeaves(world, x, y + l3, z2)) continue;
            this.a(world, x, y + l3, z2, TreeBlock.TRUNK.getID(), TreeBlock.TRUNK.getMetadata());
        }
        return true;
    }

    public static long getLastSeed() {
        return lastSeed;
    }

    private static enum TreeBlock {
        LEAVES(new ye((aqz)aqz.P, 1, 1)),
        TRUNK(new ye(aqz.O, 1, 1));

        private ye stack;
        private static boolean loadedCustomBlocks;

        private static void loadCustomBlocks() {
            if (Element.LEAVES_FIR.isPresent()) {
                TreeBlock.LEAVES.stack = Element.LEAVES_FIR.get();
            }
            if (Element.LOG_FIR.isPresent()) {
                TreeBlock.TRUNK.stack = Element.LOG_FIR.get();
            }
            loadedCustomBlocks = true;
        }

        private TreeBlock(ye stack) {
            this.stack = stack;
        }

        public int getID() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack.d;
        }

        public int getMetadata() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack.k();
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

