/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import codechicken.multipart.INeighborTileChange;
import codechicken.multipart.handler.MultipartSaveLoad;
import mrtjp.projectred.api.IScrewdriver;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.integration.GateLogic;
import mrtjp.projectred.integration.GatePart;
import mrtjp.projectred.integration.InstancedRsGatePart;
import mrtjp.projectred.integration.IntegrationSPH;
import mrtjp.projectred.integration.RedstoneGateLogic;
import mrtjp.projectred.integration.SimpleGatePart;

public abstract class InstancedRsGateLogic
extends RedstoneGateLogic<InstancedRsGatePart> {
    public InstancedRsGatePart gate;

    public static InstancedRsGateLogic create(InstancedRsGatePart instancedRsGatePart, int n) {
        switch (n) {
            case 12: {
                return new RSLatch(instancedRsGatePart);
            }
            case 13: {
                return new ToggleLatch(instancedRsGatePart);
            }
            case 17: {
                return new Timer(instancedRsGatePart);
            }
            case 18: {
                return new Sequencer(instancedRsGatePart);
            }
            case 19: {
                return new Counter(instancedRsGatePart);
            }
            case 20: {
                return new StateCell(instancedRsGatePart);
            }
            case 21: {
                return new Synchronizer(instancedRsGatePart);
            }
            case 26: {
                return new Comparator(instancedRsGatePart);
            }
        }
        throw new IllegalArgumentException("Invalid subID: " + n);
    }

    public InstancedRsGateLogic(InstancedRsGatePart instancedRsGatePart) {
        this.gate = instancedRsGatePart;
    }

    @Override
    public int getOutput(InstancedRsGatePart instancedRsGatePart, int n) {
        return (instancedRsGatePart.state & 16 << n) != 0 ? 15 : 0;
    }

    public void save(by by2) {
    }

    public void load(by by2) {
    }

    public void readDesc(MCDataInput mCDataInput) {
    }

    public void writeDesc(MCDataOutput mCDataOutput) {
    }

    public void read(MCDataInput mCDataInput, int n) {
    }

    public void tickSound() {
        if (Configurator.logicGateSounds) {
            this.gate.world().a((double)this.gate.x() + 0.5, (double)this.gate.y() + 0.5, (double)this.gate.z() + 0.5, "random.click", 0.3f, 0.5f);
        }
    }

    public static class Comparator
    extends InstancedRsGateLogic
    implements INeighborTileChange {
        public short state2;

        public Comparator(InstancedRsGatePart instancedRsGatePart) {
            super(instancedRsGatePart);
        }

        public int state2() {
            return this.state2 & 0xFFFF;
        }

        public void setState2(int n) {
            this.state2 = (short)n;
        }

        @Override
        public void save(by by2) {
            by2.a("state2", this.state2);
        }

        @Override
        public void load(by by2) {
            this.state2 = by2.d("state2");
        }

        @Override
        public boolean cycleShape(InstancedRsGatePart instancedRsGatePart) {
            instancedRsGatePart.setShape(instancedRsGatePart.shape() > 0 ? 0 : 1);
            return true;
        }

        @Override
        public boolean requireStrongInput(int n) {
            return n % 2 == 1;
        }

        @Override
        public boolean canConnect(int n, int n2) {
            return true;
        }

        @Override
        public int getOutput(InstancedRsGatePart instancedRsGatePart, int n) {
            if (n == 0) {
                return this.state2 & 0xF;
            }
            return 0;
        }

        public int getAnalogInput(int n) {
            return (this.gate.getRedstoneInput(n) + 16) / 17;
        }

        public int calcInputA() {
            int n = Rotation.rotateSide((int)this.gate.side(), (int)this.gate.toAbsolute(2));
            BlockCoord blockCoord = new BlockCoord((asp)this.gate.tile()).offset(n);
            aqz aqz2 = aqz.s[this.gate.world().a(blockCoord.x, blockCoord.y, blockCoord.z)];
            if (aqz2 != null) {
                if (aqz2.q_()) {
                    return aqz2.b_(this.gate.world(), blockCoord.x, blockCoord.y, blockCoord.z, n ^ 1);
                }
                if (aqz2.isBlockNormalCube(this.gate.world(), blockCoord.x, blockCoord.y, blockCoord.z)) {
                    blockCoord.offset(n);
                    aqz2 = aqz.s[this.gate.world().a(blockCoord.x, blockCoord.y, blockCoord.z)];
                    if (aqz2 != null && aqz2.q_()) {
                        return aqz2.b_(this.gate.world(), blockCoord.x, blockCoord.y, blockCoord.z, n ^ 1);
                    }
                }
            }
            return this.getAnalogInput(2);
        }

        public int calcInput() {
            return this.getAnalogInput(1) << 4 | this.calcInputA() << 8 | this.getAnalogInput(3) << 12;
        }

        public static int digitize(int n) {
            int n2 = 0;
            for (int i = 0; i < 4; ++i) {
                if ((n >> i * 4 & 0xF) <= 0) continue;
                n2 |= 1 << i;
            }
            return n2;
        }

        @Override
        public void onChange(InstancedRsGatePart instancedRsGatePart) {
            int n = this.state2 & 0xFFF0;
            int n2 = this.calcInput();
            if (n != n2) {
                this.setState2(this.state2 & 0xF | n2);
                instancedRsGatePart.setState(Comparator.digitize(n2 | this.calcOutput()) | instancedRsGatePart.state & 0xF0);
                instancedRsGatePart.onInputChange();
            }
            if ((this.state2 & 0xF) != this.calcOutput()) {
                instancedRsGatePart.scheduleTick(2);
            }
        }

        public int calcOutput() {
            if (this.gate.shape() == 0) {
                return this.inputA() >= this.inputB() ? this.inputA() : 0;
            }
            return Math.max(this.inputA() - this.inputB(), 0);
        }

        public int inputA() {
            return this.state2 >> 8 & 0xF;
        }

        public int inputB() {
            return Math.max(this.state2 >> 4 & 0xF, this.state2 >> 12 & 0xF);
        }

        @Override
        public void scheduledTick(InstancedRsGatePart instancedRsGatePart) {
            int n = this.state2 & 0xF;
            int n2 = this.calcOutput();
            if (n != n2) {
                this.setState2(this.state2 & 0xFFF0 | n2);
                instancedRsGatePart.setState(instancedRsGatePart.state() & 0xF | Comparator.digitize(n2) << 4);
                instancedRsGatePart.onOutputChange(1);
            }
        }

        public void onNeighborTileChanged(int n, boolean bl) {
            if (n == Rotation.rotateSide((int)this.gate.side(), (int)this.gate.toAbsolute(2))) {
                this.gate.onChange();
            }
        }

        public boolean weakTileChanges() {
            return true;
        }
    }

    public static class Synchronizer
    extends ExtraStateLogic {
        public Synchronizer(InstancedRsGatePart instancedRsGatePart) {
            super(instancedRsGatePart);
        }

        @Override
        public void onChange(InstancedRsGatePart instancedRsGatePart) {
            int n = instancedRsGatePart.state() & 0xF;
            int n2 = this.getInput(instancedRsGatePart, 14);
            int n3 = n2 & ~n;
            if (n != n2) {
                instancedRsGatePart.setState(instancedRsGatePart.state() & 0xF0 | n2);
                instancedRsGatePart.onInputChange();
                if ((n2 & 4) != 0) {
                    this.off();
                } else {
                    if ((n3 & 2) != 0) {
                        this.setRight();
                    }
                    if ((n3 & 8) != 0) {
                        this.setLeft();
                    }
                }
                if (this.right() && this.left()) {
                    instancedRsGatePart.scheduleTick(2);
                }
            }
        }

        @Override
        public void scheduledTick(InstancedRsGatePart instancedRsGatePart) {
            if (!this.pulsing() && this.right() && this.left()) {
                instancedRsGatePart.setState(instancedRsGatePart.state() | 0x10);
                instancedRsGatePart.onOutputChange(1);
                this.setPulsing();
                instancedRsGatePart.scheduleTick(2);
            } else if (this.pulsing()) {
                instancedRsGatePart.setState(instancedRsGatePart.state() & 0xFFFFFFEF);
                instancedRsGatePart.onOutputChange(1);
                this.off();
            }
        }

        public boolean right() {
            return (this.state2() & 1) != 0;
        }

        public boolean left() {
            return (this.state2() & 2) != 0;
        }

        public boolean pulsing() {
            return (this.state2() & 4) != 0;
        }

        public void setPulsing() {
            int n = this.state2();
            this.setState2(this.state2() | 4);
            if (this.state2() != n) {
                this.sendState2Update();
            }
        }

        public void setRight() {
            int n = this.state2();
            this.setState2(this.state2() | 1);
            if (this.state2() != n) {
                this.sendState2Update();
            }
        }

        public void setLeft() {
            int n = this.state2();
            this.setState2(this.state2() | 2);
            if (this.state2() != n) {
                this.sendState2Update();
            }
        }

        public void off() {
            int n = this.state2();
            this.setState2(0);
            if (this.state2() != n) {
                this.sendState2Update();
            }
        }

        @Override
        public int outputMask(int n) {
            return 1;
        }

        @Override
        public int inputMask(int n) {
            return 14;
        }
    }

    public static class Counter
    extends InstancedRsGateLogic
    implements GateLogic.ICounterGuiLogic {
        public int value = 0;
        public int max = 10;
        public int incr = 1;
        public int decr = 1;

        public Counter(InstancedRsGatePart instancedRsGatePart) {
            super(instancedRsGatePart);
        }

        @Override
        public void save(by by2) {
            by2.a("val", this.value);
            by2.a("max", this.max);
            by2.a("inc", this.incr);
            by2.a("dec", this.decr);
        }

        @Override
        public void load(by by2) {
            this.value = by2.e("val");
            this.max = by2.e("max");
            this.incr = by2.e("inc");
            this.decr = by2.e("dec");
        }

        @Override
        public int getCounterValue() {
            return this.value;
        }

        @Override
        public int getCounterMax() {
            return this.max;
        }

        @Override
        public int getCounterIncr() {
            return this.incr;
        }

        @Override
        public int getCounterDecr() {
            return this.decr;
        }

        @Override
        public void setCounterValue(GatePart gatePart, int n) {
            int n2 = this.value;
            this.value = Math.min(this.max, Math.max(0, n));
            if (this.value != n2) {
                this.tickSound();
                this.sendValueUpdate();
            }
        }

        @Override
        public void setCounterMax(GatePart gatePart, int n) {
            int n2 = this.max;
            this.max = Math.min(Short.MAX_VALUE, Math.max(1, n));
            if (this.max != n2) {
                this.tickSound();
                this.sendMaxUpdate();
                int n3 = this.value;
                this.value = Math.min(this.max, Math.max(0, n));
                if (this.value != n3) {
                    this.sendValueUpdate();
                    gatePart.scheduleTick(2);
                }
            }
        }

        @Override
        public void setCounterIncr(GatePart gatePart, int n) {
            int n2 = this.incr;
            this.incr = Math.min(this.max, Math.max(1, n));
            if (this.incr != n2) {
                this.tickSound();
                this.sendIncrUpdate();
            }
        }

        @Override
        public void setCounterDecr(GatePart gatePart, int n) {
            int n2 = this.decr;
            this.decr = Math.min(this.max, Math.max(1, n));
            if (this.decr != n2) {
                this.tickSound();
                this.sendDecrUpdate();
            }
        }

        @Override
        public void read(MCDataInput mCDataInput, int n) {
            if (n == 11) {
                this.value = mCDataInput.readInt();
            } else if (n == 12) {
                this.max = mCDataInput.readInt();
            } else if (n == 13) {
                this.incr = mCDataInput.readInt();
            } else if (n == 14) {
                this.decr = mCDataInput.readInt();
            }
        }

        @Override
        public void writeDesc(MCDataOutput mCDataOutput) {
            mCDataOutput.writeInt(this.value).writeInt(this.max).writeInt(this.incr).writeInt(this.decr);
        }

        @Override
        public void readDesc(MCDataInput mCDataInput) {
            this.value = mCDataInput.readInt();
            this.max = mCDataInput.readInt();
            this.incr = mCDataInput.readInt();
            this.decr = mCDataInput.readInt();
        }

        public void sendValueUpdate() {
            this.gate.getWriteStream(11).writeInt(this.value);
        }

        public void sendMaxUpdate() {
            this.gate.getWriteStream(12).writeInt(this.max);
        }

        public void sendIncrUpdate() {
            this.gate.getWriteStream(13).writeInt(this.incr);
        }

        public void sendDecrUpdate() {
            this.gate.getWriteStream(14).writeInt(this.decr);
        }

        @Override
        public void onChange(InstancedRsGatePart instancedRsGatePart) {
            int n;
            int n2 = instancedRsGatePart.state() & 0xF;
            int n3 = this.getInput(instancedRsGatePart, 10);
            if (instancedRsGatePart.shape() == 1) {
                n3 = GatePart.flipMaskZ(n3);
            }
            if (((n = n3 & ~n2) & 2) != 0) {
                this.setCounterValue(instancedRsGatePart, this.value + this.incr);
            }
            if ((n & 8) != 0) {
                this.setCounterValue(instancedRsGatePart, this.value - this.decr);
            }
            if (n2 != n3) {
                instancedRsGatePart.setState(instancedRsGatePart.state() & 0xF0 | n3);
                instancedRsGatePart.onInputChange();
                instancedRsGatePart.scheduleTick(2);
            }
        }

        @Override
        public boolean cycleShape(InstancedRsGatePart instancedRsGatePart) {
            instancedRsGatePart.setShape(instancedRsGatePart.shape() == 1 ? 0 : 1);
            return true;
        }

        @Override
        public void scheduledTick(InstancedRsGatePart instancedRsGatePart) {
            int n = instancedRsGatePart.state();
            int n2 = 0;
            if (this.value == this.max) {
                n2 = 1;
            } else if (this.value == 0) {
                n2 = 4;
            }
            if (n2 != n) {
                instancedRsGatePart.setState(instancedRsGatePart.state() & 0xF | n2 << 4);
            }
            if (n2 != n) {
                instancedRsGatePart.onOutputChange(5);
            }
        }

        @Override
        public int outputMask(int n) {
            return 5;
        }

        @Override
        public int inputMask(int n) {
            return 10;
        }

        @Override
        public boolean activate(InstancedRsGatePart instancedRsGatePart, uf uf2, ye ye2) {
            if (ye2 == null || !(ye2.b() instanceof IScrewdriver)) {
                if (!instancedRsGatePart.world().I) {
                    IntegrationSPH.openCounterGui(uf2, instancedRsGatePart);
                }
                return true;
            }
            return false;
        }
    }

    public static class Sequencer
    extends InstancedRsGateLogic
    implements GateLogic.ITimerGuiLogic {
        public int pointer_max = 40;

        public Sequencer(InstancedRsGatePart instancedRsGatePart) {
            super(instancedRsGatePart);
        }

        @Override
        public void onChange(InstancedRsGatePart instancedRsGatePart) {
        }

        @Override
        public void scheduledTick(InstancedRsGatePart instancedRsGatePart) {
        }

        @Override
        public int getTimerMax() {
            return this.pointer_max;
        }

        @Override
        public void setTimerMax(GatePart gatePart, int n) {
            if (n < 4) {
                n = 4;
            }
            if (n != this.pointer_max) {
                this.pointer_max = n;
                this.sendPointerMaxUpdate();
            }
        }

        @Override
        public void save(by by2) {
            by2.a("pmax", this.pointer_max);
        }

        @Override
        public void load(by by2) {
            this.pointer_max = by2.e("pmax");
        }

        @Override
        public void writeDesc(MCDataOutput mCDataOutput) {
            mCDataOutput.writeInt(this.pointer_max);
        }

        @Override
        public void readDesc(MCDataInput mCDataInput) {
            this.pointer_max = mCDataInput.readInt();
        }

        @Override
        public void read(MCDataInput mCDataInput, int n) {
            if (n == 11) {
                this.pointer_max = mCDataInput.readInt();
            }
        }

        public void sendPointerMaxUpdate() {
            this.gate.getWriteStream(11).writeInt(this.pointer_max);
        }

        @Override
        public void onTick(InstancedRsGatePart instancedRsGatePart) {
            if (!instancedRsGatePart.world().I) {
                int n = instancedRsGatePart.state() >> 4;
                int n2 = 1 << (int)(instancedRsGatePart.world().J() % (long)this.pointer_max / (long)(this.pointer_max / 4));
                if (instancedRsGatePart.shape() == 1) {
                    n2 = GatePart.flipMaskZ(n2);
                }
                if (n != n2) {
                    instancedRsGatePart.setState(n2 << 4);
                    instancedRsGatePart.onOutputChange(15);
                    this.tickSound();
                }
            }
        }

        @Override
        public boolean cycleShape(InstancedRsGatePart instancedRsGatePart) {
            instancedRsGatePart.setShape(instancedRsGatePart.shape() == 1 ? 0 : 1);
            return true;
        }

        @Override
        public boolean activate(InstancedRsGatePart instancedRsGatePart, uf uf2, ye ye2) {
            if (ye2 == null || !(ye2.b() instanceof IScrewdriver)) {
                if (!instancedRsGatePart.world().I) {
                    IntegrationSPH.openTimerGui(uf2, instancedRsGatePart);
                }
                return true;
            }
            return false;
        }

        @Override
        public int outputMask(int n) {
            return 15;
        }

        @Override
        public int inputMask(int n) {
            return 0;
        }
    }

    public static class StateCell
    extends TimerGateLogic {
        public byte state2;

        public StateCell(InstancedRsGatePart instancedRsGatePart) {
            super(instancedRsGatePart);
        }

        public int state2() {
            return this.state2 & 0xFF;
        }

        public void setState2(int n) {
            this.state2 = (byte)n;
        }

        @Override
        public void save(by by2) {
            super.save(by2);
            by2.a("state2", this.state2);
        }

        @Override
        public void load(by by2) {
            super.load(by2);
            this.state2 = by2.c("state2");
        }

        @Override
        public void readDesc(MCDataInput mCDataInput) {
            super.readDesc(mCDataInput);
            this.state2 = mCDataInput.readByte();
        }

        @Override
        public void writeDesc(MCDataOutput mCDataOutput) {
            super.writeDesc(mCDataOutput);
            mCDataOutput.writeByte((int)this.state2);
        }

        @Override
        public void read(MCDataInput mCDataInput, int n) {
            if (n == 11) {
                this.state2 = mCDataInput.readByte();
            } else {
                super.read(mCDataInput, n);
            }
        }

        public void sendState2Update() {
            this.gate.getWriteStream(11).writeByte((int)this.state2);
        }

        @Override
        public boolean cycleShape(InstancedRsGatePart instancedRsGatePart) {
            instancedRsGatePart.setShape((instancedRsGatePart.shape() + 1) % 2);
            return true;
        }

        @Override
        public int outputMask(int n) {
            int n2 = 9;
            if (n == 1) {
                n2 = GatePart.flipMaskZ(n2);
            }
            return n2;
        }

        @Override
        public int inputMask(int n) {
            int n2 = 6;
            if (n == 1) {
                n2 = GatePart.flipMaskZ(n2);
            }
            return n2;
        }

        @Override
        public void onChange(InstancedRsGatePart instancedRsGatePart) {
            int n;
            int n2 = instancedRsGatePart.state() & 0xF;
            if (n2 != (n = this.getInput(instancedRsGatePart, 14))) {
                instancedRsGatePart.setState(instancedRsGatePart.state() & 0xF0 | n);
                instancedRsGatePart.onInputChange();
                if (instancedRsGatePart.shape() == 1) {
                    n = GatePart.flipMaskZ(n);
                }
                if ((n & 4) != 0 && this.state2 == 0) {
                    this.setState2(1);
                    this.sendState2Update();
                    instancedRsGatePart.scheduleTick(2);
                }
                if (this.state2 != 0) {
                    if ((n & 6) != 0) {
                        this.resetPointer();
                    } else {
                        this.startPointer();
                    }
                }
            }
        }

        @Override
        public void pointerTick() {
            this.resetPointer();
            if (!this.gate.world().I) {
                this.setState2(0);
                this.sendState2Update();
                this.gate.setState(0x10 | this.gate.state() & 0xF);
                this.gate.onOutputChange(this.outputMask(this.gate.shape()));
                this.gate.scheduleTick(2);
                this.tickSound();
            }
        }

        @Override
        public void scheduledTick(InstancedRsGatePart instancedRsGatePart) {
            int n = 0;
            if (this.state2 != 0) {
                n = 8;
            }
            if (instancedRsGatePart.shape() == 1) {
                n = GatePart.flipMaskZ(n);
            }
            instancedRsGatePart.setState(n << 4 | instancedRsGatePart.state() & 0xF);
            instancedRsGatePart.onOutputChange(this.outputMask(instancedRsGatePart.shape()));
        }
    }

    public static class Timer
    extends TimerGateLogic {
        public Timer(InstancedRsGatePart instancedRsGatePart) {
            super(instancedRsGatePart);
        }

        @Override
        public int outputMask(int n) {
            return 11;
        }

        @Override
        public int inputMask(int n) {
            return 14;
        }

        @Override
        public void setup(InstancedRsGatePart instancedRsGatePart) {
            this.startPointer();
        }

        @Override
        public void scheduledTick(InstancedRsGatePart instancedRsGatePart) {
            instancedRsGatePart.setState(instancedRsGatePart.state() & 0xF);
            instancedRsGatePart.onOutputChange(11);
            this.onChange(instancedRsGatePart);
        }

        @Override
        public void onChange(InstancedRsGatePart instancedRsGatePart) {
            int n = instancedRsGatePart.state() & 0xF;
            int n2 = this.getInput(instancedRsGatePart, 14);
            if (n2 != n) {
                instancedRsGatePart.setState(instancedRsGatePart.state() & 0xF0 | n2);
                instancedRsGatePart.onInputChange();
            }
            if (instancedRsGatePart.schedTime < 0L) {
                if (n2 > 0) {
                    this.resetPointer();
                } else {
                    this.startPointer();
                }
            }
        }

        @Override
        public void pointerTick() {
            this.resetPointer();
            if (!this.gate.world().I) {
                this.gate.scheduleTick(2);
                this.gate.setState(0xB0 | this.gate.state() & 0xF);
                this.gate.onOutputChange(11);
                this.tickSound();
            }
        }
    }

    public static abstract class TimerGateLogic
    extends InstancedRsGateLogic
    implements GateLogic.ITimerGuiLogic {
        public int pointer_max = 38;
        public long pointer_start = -1L;

        public TimerGateLogic(InstancedRsGatePart instancedRsGatePart) {
            super(instancedRsGatePart);
        }

        @Override
        public void save(by by2) {
            by2.a("pmax", this.pointer_max);
            by2.a("pelapsed", this.pointer_start < 0L ? this.pointer_start : this.gate.world().I() - this.pointer_start);
        }

        @Override
        public void load(by by2) {
            this.pointer_max = by2.e("pmax");
            this.pointer_start = by2.f("pelapsed");
            if (this.pointer_start >= 0L) {
                this.pointer_start = MultipartSaveLoad.loadingWorld().I() - this.pointer_start;
            }
        }

        @Override
        public void writeDesc(MCDataOutput mCDataOutput) {
            mCDataOutput.writeInt(this.pointer_max);
            mCDataOutput.writeLong(this.pointer_start);
        }

        @Override
        public void readDesc(MCDataInput mCDataInput) {
            this.pointer_max = mCDataInput.readInt();
            this.pointer_start = mCDataInput.readLong();
        }

        @Override
        public void read(MCDataInput mCDataInput, int n) {
            if (n == 12) {
                this.pointer_max = mCDataInput.readInt();
            } else if (n == 13) {
                this.pointer_start = mCDataInput.readInt();
                if (this.pointer_start >= 0L) {
                    this.pointer_start = this.gate.world().I() - this.pointer_start;
                }
            }
        }

        public int pointerValue() {
            if (this.pointer_start < 0L) {
                return 0;
            }
            return (int)(this.gate.world().I() - this.pointer_start);
        }

        public void sendPointerMaxUpdate() {
            this.gate.getWriteStream(12).writeInt(this.pointer_max);
        }

        public void sendPointerUpdate() {
            this.gate.getWriteStream(13).writeInt(this.pointer_start < 0L ? -1 : this.pointerValue());
        }

        @Override
        public int getTimerMax() {
            return this.pointer_max + 2;
        }

        @Override
        public void setTimerMax(GatePart gatePart, int n) {
            if (n < 4) {
                n = 4;
            }
            if (n != this.pointer_max) {
                this.pointer_max = n - 2;
                this.sendPointerMaxUpdate();
            }
        }

        @Override
        public void onTick(InstancedRsGatePart instancedRsGatePart) {
            if (this.pointer_start >= 0L) {
                if (instancedRsGatePart.world().I() >= this.pointer_start + (long)this.pointer_max) {
                    this.pointerTick();
                } else if (this.pointer_start > instancedRsGatePart.world().I()) {
                    this.pointer_start = instancedRsGatePart.world().I();
                }
            }
        }

        public abstract void pointerTick();

        public void resetPointer() {
            if (this.pointer_start >= 0L) {
                this.pointer_start = -1L;
                this.gate.tile().markDirty();
                if (!this.gate.world().I) {
                    this.sendPointerUpdate();
                }
            }
        }

        public void startPointer() {
            if (this.pointer_start < 0L) {
                this.pointer_start = this.gate.world().I();
                this.gate.tile().markDirty();
                if (!this.gate.world().I) {
                    this.sendPointerUpdate();
                }
            }
        }

        public float interpPointer(float f) {
            if (this.pointer_start < 0L) {
                return 0.0f;
            }
            return ((float)this.pointerValue() + f) / (float)this.pointer_max;
        }

        @Override
        public boolean activate(InstancedRsGatePart instancedRsGatePart, uf uf2, ye ye2) {
            if (ye2 == null || !(ye2.b() instanceof IScrewdriver)) {
                if (!instancedRsGatePart.world().I) {
                    IntegrationSPH.openTimerGui(uf2, instancedRsGatePart);
                }
                return true;
            }
            return false;
        }
    }

    public static class ToggleLatch
    extends ExtraStateLogic {
        public ToggleLatch(InstancedRsGatePart instancedRsGatePart) {
            super(instancedRsGatePart);
        }

        @Override
        public int outputMask(int n) {
            return 5;
        }

        @Override
        public int inputMask(int n) {
            return 10;
        }

        @Override
        public boolean clientState2() {
            return true;
        }

        @Override
        public void setup(InstancedRsGatePart instancedRsGatePart) {
            instancedRsGatePart.setState(16);
            instancedRsGatePart.sendStateUpdate();
        }

        @Override
        public void onChange(InstancedRsGatePart instancedRsGatePart) {
            int n = instancedRsGatePart.state() & 0xF;
            int n2 = this.getInput(instancedRsGatePart, 10);
            int n3 = n2 & ~n;
            if (n3 == 2 || n3 == 8) {
                this.toggle(instancedRsGatePart);
            }
            if (n != n2) {
                instancedRsGatePart.setState(instancedRsGatePart.state() & 0xF0 | n2);
                instancedRsGatePart.onInputChange();
            }
        }

        @Override
        public void scheduledTick(InstancedRsGatePart instancedRsGatePart) {
            int n;
            int n2 = instancedRsGatePart.state() >> 4;
            int n3 = n = this.state2 == 0 ? 1 : 4;
            if (n2 != n) {
                instancedRsGatePart.setState(n << 4 | instancedRsGatePart.state() & 0xF);
                instancedRsGatePart.onOutputChange(this.outputMask(5));
            }
            this.onChange(instancedRsGatePart);
        }

        @Override
        public boolean activate(InstancedRsGatePart instancedRsGatePart, uf uf2, ye ye2) {
            if (ye2 == null || !(ye2.b() instanceof IScrewdriver)) {
                if (!instancedRsGatePart.world().I) {
                    this.toggle(instancedRsGatePart);
                }
                return true;
            }
            return false;
        }

        private void toggle(InstancedRsGatePart instancedRsGatePart) {
            this.setState2(this.state2 ^ 1);
            instancedRsGatePart.scheduleTick(2);
            this.tickSound();
        }
    }

    public static class RSLatch
    extends ExtraStateLogic {
        public RSLatch(InstancedRsGatePart instancedRsGatePart) {
            super(instancedRsGatePart);
        }

        @Override
        public boolean cycleShape(InstancedRsGatePart instancedRsGatePart) {
            int n = (instancedRsGatePart.shape() + 1) % 4;
            instancedRsGatePart.setShape(n);
            this.setState2(GatePart.flipMaskZ(this.state2()));
            instancedRsGatePart.setState(GatePart.flipMaskZ(instancedRsGatePart.state()));
            instancedRsGatePart.onOutputChange(15);
            instancedRsGatePart.scheduleTick(2);
            return true;
        }

        @Override
        public int outputMask(int n) {
            return n >> 1 == 0 ? 15 : 5;
        }

        @Override
        public int inputMask(int n) {
            return 10;
        }

        @Override
        public void setup(InstancedRsGatePart instancedRsGatePart) {
            this.setState2(2);
            instancedRsGatePart.setState(48);
        }

        @Override
        public void onChange(InstancedRsGatePart instancedRsGatePart) {
            int n = this.state2();
            int n2 = instancedRsGatePart.state() & 0xF;
            int n3 = this.getInput(instancedRsGatePart, 10);
            int n4 = instancedRsGatePart.state() >> 4;
            if (n3 != n2) {
                if (n != 10 && n3 != 0 && n3 != this.state2()) {
                    instancedRsGatePart.setState(n3);
                    this.setState2(n3);
                    instancedRsGatePart.onOutputChange(n4);
                    instancedRsGatePart.scheduleTick(2);
                } else {
                    instancedRsGatePart.setState(n4 << 4 | n3);
                    instancedRsGatePart.onInputChange();
                }
            }
        }

        @Override
        public void scheduledTick(InstancedRsGatePart instancedRsGatePart) {
            int n;
            int n2 = instancedRsGatePart.state() >> 4;
            if (n2 != (n = this.calcOutput(instancedRsGatePart))) {
                instancedRsGatePart.setState(instancedRsGatePart.state() & 0xF | n << 4);
                instancedRsGatePart.onOutputChange(this.outputMask(instancedRsGatePart.shape()));
            }
            this.onChange(instancedRsGatePart);
        }

        public int calcOutput(SimpleGatePart simpleGatePart) {
            int n = simpleGatePart.state() & 0xF;
            int n2 = this.state2();
            if ((simpleGatePart.shape & 1) != 0) {
                n = GatePart.flipMaskZ(n);
                n2 = GatePart.flipMaskZ(n2);
            }
            if (n2 == 10) {
                if (n == 10) {
                    simpleGatePart.scheduleTick(2);
                    return 0;
                }
                n2 = n == 0 ? (simpleGatePart.world().s.nextBoolean() ? 2 : 8) : n;
                this.setState2(n2);
            }
            int n3 = GatePart.shiftMask(n2, 1);
            if ((simpleGatePart.shape & 2) == 0) {
                n3 |= n2;
            }
            if ((simpleGatePart.shape & 1) != 0) {
                n3 = GatePart.flipMaskZ(n3);
            }
            return n3;
        }
    }

    public static abstract class ExtraStateLogic
    extends InstancedRsGateLogic {
        public byte state2;

        public ExtraStateLogic(InstancedRsGatePart instancedRsGatePart) {
            super(instancedRsGatePart);
        }

        public int state2() {
            return this.state2 & 0xFF;
        }

        public void setState2(int n) {
            this.state2 = (byte)n;
        }

        @Override
        public void save(by by2) {
            by2.a("state2", this.state2);
        }

        @Override
        public void load(by by2) {
            this.state2 = by2.c("state2");
        }

        @Override
        public void readDesc(MCDataInput mCDataInput) {
            if (this.clientState2()) {
                this.state2 = mCDataInput.readByte();
            }
        }

        @Override
        public void writeDesc(MCDataOutput mCDataOutput) {
            if (this.clientState2()) {
                mCDataOutput.writeByte((int)this.state2);
            }
        }

        @Override
        public void read(MCDataInput mCDataInput, int n) {
            if (n == 11) {
                this.state2 = mCDataInput.readByte();
            }
        }

        public boolean clientState2() {
            return false;
        }

        public void sendState2Update() {
            this.gate.getWriteStream(11).writeByte((int)this.state2);
        }
    }
}

