/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.multipart.RedstoneInteractions;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import java.util.Arrays;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.integration.ArrayCommons;
import mrtjp.projectred.integration.SimpleGatePart;
import mrtjp.projectred.transmission.IRedwireEmitter;
import mrtjp.projectred.transmission.IRedwirePart;
import mrtjp.projectred.transmission.IWirePart;
import mrtjp.projectred.transmission.WirePropogator;

public class RowGatePart
extends SimpleGatePart
implements IRedwirePart,
ArrayCommons.ITopArrayWire {
    public byte signal;

    @Override
    public String getType() {
        return "pr_rgate";
    }

    @Override
    public void save(by by2) {
        super.save(by2);
        by2.a("signal", this.signal);
    }

    @Override
    public void load(by by2) {
        super.load(by2);
        this.signal = by2.c("signal");
    }

    @Override
    public void writeDesc(MCDataOutput mCDataOutput) {
        super.writeDesc(mCDataOutput);
        mCDataOutput.writeByte((int)this.signal);
    }

    @Override
    public void readDesc(MCDataInput mCDataInput) {
        super.readDesc(mCDataInput);
        this.signal = mCDataInput.readByte();
    }

    @Override
    public void read(MCDataInput mCDataInput, int n) {
        if (n == 11) {
            this.signal = mCDataInput.readByte();
            if (Configurator.staticGates) {
                this.tile().markRender();
            }
        } else {
            super.read(mCDataInput, n);
        }
    }

    @Override
    public void updateAndPropogate(TMultiPart tMultiPart, int n) {
        int n2 = this.wireMask(tMultiPart);
        if ((n2 & 2) != 0) {
            this._updateAndPropogate(tMultiPart, n);
        } else {
            WirePropogator.addNeighborChange(new BlockCoord((asp)this.tile()));
        }
    }

    private void _updateAndPropogate(TMultiPart tMultiPart, int n) {
        int n2 = this.signal & 0xFF;
        if (n == 1 && n2 == 0) {
            return;
        }
        int n3 = this.calculateSignal();
        if (n3 < n2) {
            if (n3 > 0) {
                WirePropogator.propogateAnalogDrop(this);
            }
            this.signal = 0;
            this.propogate(tMultiPart, 1);
        } else if (n3 > n2) {
            this.signal = (byte)n3;
            if (n == 1) {
                this.propogate(null, 0);
            } else {
                this.propogate(tMultiPart, 0);
            }
        } else if (n == 1) {
            this.propogateTo(tMultiPart, 0);
        } else if (n == 2) {
            this.propogate(tMultiPart, 3);
        }
    }

    public int calculateSignal() {
        WirePropogator.setWiresProvidePower(false);
        WirePropogator.redwiresProvidePower = false;
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2;
            if (this.toInternal(i) % 2 == 0 || (n2 = (this.connMap & 1 << i) != 0 ? this.calculateCornerSignal(i) : this.calculateStraightSignal(i)) <= n) continue;
            n = n2;
        }
        WirePropogator.setWiresProvidePower(true);
        WirePropogator.redwiresProvidePower = true;
        return n;
    }

    @Override
    public int calculateCornerSignal(int n) {
        int n2 = Rotation.rotateSide((int)this.side(), (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n2);
        BlockCoord blockCoord2 = blockCoord.copy().offset(this.side());
        TileMultipart tileMultipart = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)blockCoord2);
        if (tileMultipart != null) {
            return this.getPartSignal(tileMultipart.partMap(n2 ^ 1), Rotation.rotationTo((int)(n2 ^ 1), (int)(this.side() ^ 1)));
        }
        return 0;
    }

    @Override
    public int calculateStraightSignal(int n) {
        int n2 = Rotation.rotateSide((int)this.side(), (int)n);
        int n3 = 0;
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n2);
        TileMultipart tileMultipart = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)blockCoord);
        if (tileMultipart != null && (this.connMap & 16 << n) != 0) {
            TMultiPart tMultiPart = tileMultipart.partMap(this.side());
            if (tMultiPart != null) {
                n3 = this.getPartSignal(tMultiPart, (n + 2) % 4);
            }
        } else {
            int n4 = this.world().a(blockCoord.x, blockCoord.y, blockCoord.z);
            if (n4 == aqz.aA.cF) {
                return this.world().h(blockCoord.x, blockCoord.y, blockCoord.z) - 1;
            }
        }
        int n5 = this.calculateRedstoneSignal(n);
        if (n5 > n3) {
            n3 = n5;
        }
        return n3;
    }

    @Override
    public int calculateRedstoneSignal(int n) {
        int n2 = Rotation.rotateSide((int)this.side(), (int)n);
        int n3 = RedstoneInteractions.getPowerTo((TMultiPart)this, (int)n2) * 17;
        if (n3 > 0) {
            return n3;
        }
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n2);
        return this.world().l(blockCoord.x, blockCoord.y, blockCoord.z, n2) * 17;
    }

    @Override
    public int getPartSignal(TMultiPart tMultiPart, int n) {
        if (tMultiPart instanceof IRedwirePart && ((IRedwirePart)tMultiPart).isWireSide(n)) {
            return ((IRedwirePart)tMultiPart).getRedwireSignal(n) - 1;
        }
        if (tMultiPart instanceof IRedwireEmitter) {
            return ((IRedwireEmitter)tMultiPart).getRedwireSignal(n);
        }
        return 0;
    }

    @Override
    public void onSignalUpdate() {
        this.tile().markDirty();
        super.onChange();
        this.getWriteStream(11).writeByte((int)this.signal);
    }

    public void propogate(TMultiPart tMultiPart, int n) {
        if (n != 3) {
            WirePropogator.addPartChange((TMultiPart)this);
        }
        for (int i = 0; i < 4; ++i) {
            if (this.toInternal(i) % 2 == 0) continue;
            if ((this.connMap & 1 << i) != 0) {
                this.propogateCorner(i, tMultiPart, n);
                continue;
            }
            this.propogateStraight(i, tMultiPart, n);
        }
    }

    public void propogateCorner(int n, TMultiPart tMultiPart, int n2) {
        int n3 = Rotation.rotateSide((int)this.side(), (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n3).offset(this.side());
        TileMultipart tileMultipart = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)blockCoord);
        if (tileMultipart != null) {
            TMultiPart tMultiPart2 = tileMultipart.partMap(n3 ^ 1);
            if (tMultiPart2 == tMultiPart) {
                return;
            }
            if (this.propogateTo(tMultiPart2, n2)) {
                return;
            }
        }
        WirePropogator.addNeighborChange(blockCoord);
    }

    public void propogateStraight(int n, TMultiPart tMultiPart, int n2) {
        int n3 = Rotation.rotateSide((int)this.side(), (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n3);
        TileMultipart tileMultipart = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)blockCoord);
        if (tileMultipart != null) {
            TMultiPart tMultiPart2 = tileMultipart.partMap(this.side());
            if (tMultiPart2 == tMultiPart) {
                return;
            }
            if (this.propogateTo(tMultiPart2, n2)) {
                return;
            }
        }
        WirePropogator.addNeighborChange(blockCoord);
    }

    public int wireMask(TMultiPart tMultiPart) {
        if (tMultiPart.tile() == null) {
            return 3;
        }
        if (this.sideDiff(tMultiPart) == Rotation.rotateSide((int)this.side(), (int)this.toAbsolute(0)) >> 1) {
            return 1;
        }
        return 2;
    }

    public int sideDiff(TMultiPart tMultiPart) {
        int n = this.side() >> 1;
        if (n != 0 && this.y() != tMultiPart.y()) {
            return 0;
        }
        if (n != 1 && this.z() != tMultiPart.z()) {
            return 1;
        }
        return 2;
    }

    public boolean propogateTo(TMultiPart tMultiPart, int n) {
        if (tMultiPart instanceof IWirePart) {
            WirePropogator.propogateTo((IWirePart)tMultiPart, (TMultiPart)this, n);
            return true;
        }
        return false;
    }

    @Override
    public int getRedwireSignal(int n) {
        int n2 = this.toInternal(n);
        return n2 % 2 == 0 ? this.getLogic().getOutput(this, n2) * 17 : this.signal & 0xFF;
    }

    @Override
    public void onChange() {
        super.onChange();
        WirePropogator.propogateTo(this, 0);
    }

    @Override
    public boolean canConnectRedstone(int n) {
        if ((n & 6) == (this.side() & 6)) {
            return false;
        }
        int n2 = this.relRot(n);
        if (n2 % 2 != 0) {
            return true;
        }
        return this.getLogic().canConnect(this, n2);
    }

    @Override
    public int weakPowerLevel(int n) {
        if ((n & 6) == (this.side() & 6)) {
            return 0;
        }
        int n2 = this.relRot(n);
        if (n2 % 2 != 0) {
            return this.rsLevel(this.signal & 0xFF);
        }
        return super.weakPowerLevel(n);
    }

    public int rsLevel(int n) {
        if (WirePropogator.redwiresProvidePower) {
            return (n + 16) / 17;
        }
        return 0;
    }

    @Override
    public boolean isWireSide(int n) {
        if (n < 0) {
            return false;
        }
        return this.toInternal(n) % 2 != 0;
    }

    @Override
    public Cuboid6 getBounds() {
        return ArrayCommons.cBoxes[this.side()];
    }

    @Override
    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(ArrayCommons.oBoxes[this.side()]);
    }
}

