/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.config.ForestryBlock;
import forestry.core.worldgen.BlockType;
import forestry.core.worldgen.WorldGenBase;

public class WorldGenKapok
extends WorldGenTree {
    public WorldGenKapok(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth, 0.6f);
        this.generateSupportStems(this.height, this.girth, 0.2f, 0.2f);
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(leafSpawn--, 0.5f, 1, this.leaf);
        this.generateAdjustedCylinder(leafSpawn--, 1.9f, 1, this.leaf);
        while (leafSpawn > this.height - 4) {
            this.generateAdjustedCylinder(leafSpawn--, 2.5f, 1, this.leaf);
        }
        this.generateAdjustedCylinder(leafSpawn--, 1.9f, 1, this.leaf);
        for (int times = 0; times < this.height / 4; ++times) {
            int h = 10 + this.rand.nextInt(Math.max(1, this.height - 10));
            if (this.rand.nextBoolean() && h < this.height / 2) {
                h = this.height / 2 + this.rand.nextInt(this.height / 2);
            }
            int x_off = -1 + this.rand.nextInt(3);
            int y_off = -1 + this.rand.nextInt(3);
            this.generateSphere(new WorldGenBase.Vector(x_off, h, y_off), 1 + this.rand.nextInt(1), this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        }
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(10, 8);
        this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
    }

    @Override
    public BlockType getWood() {
        return new BlockType(ForestryBlock.log3.field_71990_ca, 0);
    }
}

