/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividualLiving;
import forestry.core.genetics.Individual;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class IndividualLiving
extends Individual
implements IIndividualLiving {
    protected int generation;
    protected boolean isNatural;
    protected boolean isIrregularMating;
    protected int health;
    protected int maxHealth;

    public IndividualLiving() {
    }

    public IndividualLiving(int newHealth, boolean isNatural, int generation) {
        this.health = this.maxHealth = newHealth;
        this.isNatural = isNatural;
        this.generation = generation;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.isNatural = nbttagcompound.func_74764_b("NA") ? nbttagcompound.func_74767_n("NA") : true;
        this.isIrregularMating = nbttagcompound.func_74767_n("IM");
        this.generation = nbttagcompound.func_74762_e("GEN");
        this.health = nbttagcompound.func_74762_e("Health");
        this.maxHealth = nbttagcompound.func_74762_e("MaxH");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound NBTmachine;
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("NA", this.isNatural);
        nbttagcompound.func_74757_a("IM", this.isIrregularMating);
        nbttagcompound.func_74768_a("GEN", this.generation);
        nbttagcompound.func_74768_a("Health", this.health);
        nbttagcompound.func_74768_a("MaxH", this.maxHealth);
        if (this.getGenome() != null) {
            NBTmachine = new NBTTagCompound();
            this.getGenome().writeToNBT(NBTmachine);
            nbttagcompound.func_74782_a("Genome", (NBTBase)NBTmachine);
        }
        if (this.getMate() != null) {
            NBTmachine = new NBTTagCompound();
            this.getMate().writeToNBT(NBTmachine);
            nbttagcompound.func_74782_a("Mate", (NBTBase)NBTmachine);
        }
    }

    @Override
    public abstract IGenome getMate();

    public void setIsNatural(boolean flag) {
        this.isNatural = flag;
    }

    public boolean isIrregularMating() {
        return this.isIrregularMating;
    }

    public boolean isNatural() {
        return this.isNatural;
    }

    public int getGeneration() {
        return this.generation;
    }

    @Override
    public boolean isAlive() {
        return this.health > 0;
    }

    @Override
    public int getHealth() {
        return this.health;
    }

    @Override
    public int getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public void age(World world, float lifespanModifier) {
        float ageModifier;
        if (lifespanModifier < 0.001f) {
            this.health = 0;
            return;
        }
        for (ageModifier = 1.0f / lifespanModifier; ageModifier > 1.0f; ageModifier -= 1.0f) {
            this.decreaseHealth();
        }
        if (world.field_73012_v.nextFloat() < ageModifier) {
            this.decreaseHealth();
        }
    }

    public void decreaseHealth() {
        if (this.health > 0) {
            --this.health;
        }
    }
}

