/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.EnumMutateChance;
import forestry.core.items.ItemForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class ItemResearchNote
extends ItemForestry {
    public ItemResearchNote(int id) {
        super(id);
        this.func_77637_a(null);
    }

    @Override
    public String func_77628_j(ItemStack itemstack) {
        ResearchNote note = new ResearchNote(itemstack.func_77978_p());
        return String.format("%s's Notes", note.researcher);
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        ResearchNote note = new ResearchNote(itemstack.func_77978_p());
        note.addTooltip(list);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!Proxies.common.isSimulating(world)) {
            return itemstack;
        }
        ResearchNote note = new ResearchNote(itemstack.func_77978_p());
        if (note.registerResults(world, entityplayer)) {
            entityplayer.field_71071_by.func_70298_a(entityplayer.field_71071_by.field_70461_c, 1);
            Proxies.net.inventoryChangeNotify(entityplayer);
        }
        return itemstack;
    }

    public int func_82790_a(ItemStack itemstack, int j) {
        return 16771237;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister register) {
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77617_a(int meta) {
        return Item.field_77759_aK.func_77617_a(0);
    }

    public static class ResearchNote {
        private String researcher = "fdssffd";
        private EnumNoteType type = EnumNoteType.NONE;
        private NBTTagCompound inner;

        public ResearchNote(String researcher, EnumNoteType type, NBTTagCompound inner) {
            this.researcher = researcher;
            this.type = type;
            this.inner = inner;
        }

        public ResearchNote(NBTTagCompound compound) {
            if (compound != null) {
                this.researcher = compound.func_74779_i("RES");
                this.type = EnumNoteType.VALUES[compound.func_74771_c("TYP")];
                this.inner = compound.func_74775_l("INN");
            } else {
                this.inner = new NBTTagCompound();
            }
        }

        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74778_a("RES", this.researcher);
            compound.func_74774_a("TYP", (byte)this.type.ordinal());
            compound.func_74782_a("INN", (NBTBase)this.inner);
        }

        public void addTooltip(List list) {
            ArrayList tooltips = this.type.getTooltip(this.inner);
            if (tooltips.size() <= 0) {
                list.add("\u00a7o\u00a7cIt is impossible to decipher the washed out scribbles.");
                list.add("The note has become unreadable and is worthless.");
                return;
            }
            list.addAll(tooltips);
        }

        public boolean registerResults(World world, EntityPlayer player) {
            return this.type.registerResults(world, player, this.inner);
        }
    }

    public static enum EnumNoteType {
        NONE,
        MUTATION,
        SPECIES;

        public static EnumNoteType[] VALUES;

        private IMutation getEncodedMutation(ISpeciesRoot root, NBTTagCompound compound) {
            IAllele allele0 = AlleleManager.alleleRegistry.getAllele(compound.func_74779_i("AL0"));
            IAllele allele1 = AlleleManager.alleleRegistry.getAllele(compound.func_74779_i("AL1"));
            if (allele0 == null || allele1 == null) {
                return null;
            }
            IAllele result = null;
            if (compound.func_74764_b("RST")) {
                result = AlleleManager.alleleRegistry.getAllele(compound.func_74779_i("RST"));
            }
            IMutation encoded = null;
            for (IMutation mutation : root.getCombinations(allele0)) {
                if (!mutation.isPartner(allele1) || result != null && !mutation.getTemplate()[0].getUID().equals(result.getUID())) continue;
                encoded = mutation;
                break;
            }
            return encoded;
        }

        public ArrayList getTooltip(NBTTagCompound compound) {
            ArrayList<String> tooltips = new ArrayList<String>();
            if (compound == null || this == NONE) {
                return tooltips;
            }
            if (this == MUTATION) {
                ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(compound.func_74779_i("ROT"));
                if (root == null) {
                    return tooltips;
                }
                IMutation encoded = this.getEncodedMutation(root, compound);
                if (encoded == null) {
                    return tooltips;
                }
                tooltips.add("\u00a7aMutation discovered!");
                tooltips.add(String.format("\u00a7e'%s'\u00a77 and \u00a7e'%s'\u00a77.", encoded.getAllele0().getName(), encoded.getAllele1().getName()));
                tooltips.add(String.format("Chance for success is \u00a79%s\u00a77.", new Object[]{EnumMutateChance.rateChance(encoded.getBaseChance())}));
                tooltips.add(String.format("New species is \u00a7d'%s'\u00a77.", encoded.getTemplate()[root.getKaryotypeKey().ordinal()].getName()));
                if (encoded.getSpecialConditions() != null && encoded.getSpecialConditions().size() > 0) {
                    for (String line : encoded.getSpecialConditions()) {
                        tooltips.add("\u00a76" + line);
                    }
                }
            } else if (this == SPECIES) {
                IAlleleSpecies allele0 = (IAlleleSpecies)AlleleManager.alleleRegistry.getAllele(compound.func_74779_i("AL0"));
                if (allele0 == null) {
                    return tooltips;
                }
                ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(compound.func_74779_i("ROT"));
                if (root == null) {
                    return tooltips;
                }
                tooltips.add("\u00a7aSpecies researched!");
                tooltips.add(String.format("\u00a7e'%s'\u00a77 (%s)", allele0.getName(), allele0.getBinomial()));
            }
            return tooltips;
        }

        public boolean registerResults(World world, EntityPlayer player, NBTTagCompound compound) {
            if (compound == null || this == NONE) {
                return false;
            }
            if (this == MUTATION) {
                ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(compound.func_74779_i("ROT"));
                if (root == null) {
                    return false;
                }
                IMutation encoded = this.getEncodedMutation(root, compound);
                if (encoded == null) {
                    return false;
                }
                IBreedingTracker tracker = encoded.getRoot().getBreedingTracker(world, player.field_71092_bJ);
                if (tracker.isDiscovered(encoded)) {
                    player.func_71035_c(StringUtil.localize("chat.cannotmemorizeagain"));
                    return false;
                }
                tracker.registerSpecies((IAlleleSpecies)encoded.getAllele0());
                tracker.registerSpecies((IAlleleSpecies)encoded.getAllele1());
                tracker.registerSpecies((IAlleleSpecies)encoded.getTemplate()[root.getKaryotypeKey().ordinal()]);
                tracker.registerMutation(encoded);
                player.func_71035_c(StringUtil.localize("chat.memorizednote"));
                return true;
            }
            return false;
        }

        public static ResearchNote createMutationNote(String researcher, IMutation mutation) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("ROT", mutation.getRoot().getUID());
            compound.func_74778_a("AL0", mutation.getAllele0().getUID());
            compound.func_74778_a("AL1", mutation.getAllele1().getUID());
            compound.func_74778_a("RST", mutation.getTemplate()[0].getUID());
            return new ResearchNote(researcher, MUTATION, compound);
        }

        public static ItemStack createMutationNoteStack(Item item, String researcher, IMutation mutation) {
            ResearchNote note = EnumNoteType.createMutationNote(researcher, mutation);
            NBTTagCompound compound = new NBTTagCompound("tag");
            note.writeToNBT(compound);
            ItemStack created = new ItemStack(item);
            created.func_77982_d(compound);
            return created;
        }

        public static ResearchNote createSpeciesNote(String researcher, IAlleleSpecies species) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("ROT", species.getRoot().getUID());
            compound.func_74778_a("AL0", species.getUID());
            return new ResearchNote(researcher, SPECIES, compound);
        }

        public static ItemStack createSpeciesNoteStack(Item item, String researcher, IAlleleSpecies species) {
            ResearchNote note = EnumNoteType.createSpeciesNote(researcher, species);
            NBTTagCompound compound = new NBTTagCompound("tag");
            note.writeToNBT(compound);
            ItemStack created = new ItemStack(item);
            created.func_77982_d(compound);
            return created;
        }

        static {
            VALUES = EnumNoteType.values();
        }
    }
}

