/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.core.EnumHumidity;
import forestry.api.core.ForestryAPI;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.Fluids;
import forestry.core.utils.ForestryTank;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MachineRaintank
extends TileBase
implements ISidedInventory,
ILiquidTankContainer {
    public static final short SLOT_RESOURCE = 0;
    public static final short SLOT_PRODUCT = 1;
    private static final FluidStack STACK_WATER = LiquidHelper.getLiquid("water", 10);
    public ForestryTank resourceTank = new ForestryTank(30000);
    private InventoryAdapter inventory = new InventoryAdapter(3, "Items");
    private boolean isValidBiome = true;
    private int fillingTime;
    private ItemStack usedEmpty;

    public MachineRaintank() {
        this.setHints((String[])Config.hints.get("raintank"));
        if (this.field_70331_k != null) {
            BiomeGenBase biome = Utils.getBiomeAt(this.field_70331_k, this.field_70329_l, this.field_70327_n);
            if (EnumHumidity.getFromValue(biome.field_76751_G) == EnumHumidity.ARID) {
                this.setErrorState(EnumErrorCode.INVALIDBIOME);
                this.isValidBiome = false;
            }
        }
    }

    @Override
    public String func_70303_b() {
        return "factory2.1";
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.RaintankGUI.ordinal(), player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74757_a("IsValidBiome", this.isValidBiome);
        NBTTagCompound NBTresourceSlot = new NBTTagCompound();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.func_74782_a("ResourceTank", (NBTBase)NBTresourceSlot);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.isValidBiome = nbttagcompound.func_74767_n("IsValidBiome");
        this.resourceTank = new ForestryTank(30000);
        if (nbttagcompound.func_74764_b("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.func_74775_l("ResourceTank"));
        }
        this.inventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void updateServerSide() {
        if (!this.isValidBiome) {
            this.setErrorState(EnumErrorCode.INVALIDBIOME);
        } else if (!this.field_70331_k.func_72937_j(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n)) {
            this.setErrorState(EnumErrorCode.NOSKY);
        } else if (!this.field_70331_k.func_72896_J()) {
            this.setErrorState(EnumErrorCode.NOTRAINING);
        } else {
            this.resourceTank.fill(STACK_WATER, true);
            this.setErrorState(EnumErrorCode.OK);
        }
        if (this.field_70331_k.func_82737_E() % 16L != 0L) {
            return;
        }
        if (!StackUtils.isIdenticalItem(this.usedEmpty, this.inventory.func_70301_a(0))) {
            this.fillingTime = 0;
            this.usedEmpty = null;
        }
        if (this.usedEmpty == null) {
            this.usedEmpty = this.inventory.func_70301_a(0);
        }
        if (!this.isFilling()) {
            this.tryToStartFillling();
        } else {
            --this.fillingTime;
            if (this.fillingTime <= 0 && LiquidHelper.fillContainers(this, this.inventory, 0, 1, Fluids.WATER.get())) {
                this.fillingTime = 0;
            }
        }
    }

    public boolean isFilling() {
        return this.fillingTime > 0;
    }

    private void tryToStartFillling() {
        if (!LiquidHelper.fillContainers(this, this.inventory, 0, 1, Fluids.WATER.get(), false)) {
            return;
        }
        this.fillingTime = 12;
    }

    public int getFillProgressScaled(int i) {
        return this.fillingTime * i / 12;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public InventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canTakeStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex == 1;
    }

    @Override
    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canPutStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        if (slotIndex != 0) {
            return false;
        }
        return LiquidHelper.getEmptyContainer(itemstack, STACK_WATER) != null;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fillingTime = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.fillingTime);
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!resource.isFluidEqual(STACK_WATER)) {
            return 0;
        }
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int quantityMax, boolean doEmpty) {
        return this.resourceTank.drain(quantityMax, doEmpty);
    }

    @Override
    public ForestryTank[] getTanks() {
        return new ForestryTank[]{this.resourceTank};
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowResource25);
        res.add(ForestryTrigger.lowResource10);
        res.add(ForestryTrigger.hasWork);
        return res;
    }
}

