/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.core.INBTTagable;
import forestry.core.gadgets.TileBase;
import forestry.core.gui.ContainerDummy;
import forestry.core.interfaces.ICrafter;
import forestry.core.network.ForestryPacket;
import forestry.core.network.GuiId;
import forestry.core.network.PacketTileNBT;
import forestry.core.network.PacketTileUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.PlainInventory;
import forestry.core.utils.StackUtils;
import forestry.core.utils.TileInventoryAdapter;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class TileWorktable
extends TileBase
implements ICrafter {
    public static final int SLOT_CRAFTING_1 = 0;
    public static final int SLOT_CRAFTING_RESULT = 9;
    public static final short SLOT_INVENTORY_1 = 0;
    public static final short SLOT_INVENTORY_COUNT = 18;
    private static final Container DUMMY_CONTAINER = new ContainerDummy();
    private static final RecipeBridge RECIPE_BRIDGE = new RecipeBridge();
    private Recipe currentRecipe;
    private RecipeMemory memorized;
    private TileInventoryAdapter craftingInventory = new TileInventoryAdapter(this, 10, "CraftItems");
    private TileInventoryAdapter accessibleInventory = new TileInventoryAdapter(this, 18, "Items");

    public TileWorktable() {
        this.memorized = new RecipeMemory();
    }

    @Override
    public String func_70303_b() {
        return "factory2.2";
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.WorktableGUI.ordinal(), player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        this.craftingInventory.writeToNBT(nbttagcompound);
        this.accessibleInventory.writeToNBT(nbttagcompound);
        this.memorized.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.craftingInventory.readFromNBT(nbttagcompound);
        this.accessibleInventory.readFromNBT(nbttagcompound);
        this.memorized.readFromNBT(nbttagcompound);
    }

    @Override
    public void fromPacket(ForestryPacket packetRaw) {
        if (packetRaw instanceof PacketTileUpdate) {
            super.fromPacket(packetRaw);
            return;
        }
        PacketTileNBT packet = (PacketTileNBT)packetRaw;
        this.func_70307_a(packet.getTagCompound());
    }

    public void sendAll(EntityPlayer player) {
        Proxies.net.sendToPlayer(new PacketTileNBT(5, this), player);
    }

    public RecipeMemory getMemory() {
        return this.memorized;
    }

    public void chooseRecipe(int recipeIndex) {
        if (recipeIndex == 9) {
            for (int slot = 0; slot < this.craftingInventory.func_70302_i_(); ++slot) {
                this.craftingInventory.func_70299_a(slot, null);
            }
            return;
        }
        Recipe recipe = this.memorized.getRecipe(recipeIndex);
        recipe.sanitizeMatrix();
        InventoryAdapter matrix = recipe.getMatrix();
        if (matrix == null) {
            return;
        }
        for (int slot = 0; slot < matrix.func_70302_i_(); ++slot) {
            this.craftingInventory.func_70299_a(slot, matrix.func_70301_a(slot));
        }
    }

    public void setRecipe(InventoryCrafting crafting) {
        IRecipe recipe = RECIPE_BRIDGE.getRecipe(crafting, this.field_70331_k);
        this.currentRecipe = recipe != null ? this.memorized.getOrCreateRecipe(this.field_70331_k, crafting) : null;
        this.updateCraftResult();
    }

    private void updateCraftResult() {
        ItemStack result;
        if (this.currentRecipe != null && (result = this.currentRecipe.func_77572_b(null)) != null) {
            this.craftingInventory.func_70299_a(9, result.func_77946_l());
            return;
        }
        this.craftingInventory.func_70299_a(9, null);
    }

    private boolean validateResources() {
        if (this.currentRecipe == null) {
            return false;
        }
        return StackUtils.containsSets(this.currentRecipe.getMatrix().getStacks(0, 9), this.accessibleInventory.getStacks(0, 18), this.currentRecipe.func_77571_b(), true, true) > 0;
    }

    private void removeResources(EntityPlayer player) {
        this.removeSets(1, this.craftingInventory.getStacks(0, 9), player);
    }

    private void removeSets(int count, ItemStack[] set, EntityPlayer player) {
        for (int i = 0; i < count; ++i) {
            ItemStack[] condensedSet;
            block1: for (ItemStack req : condensedSet = StackUtils.condenseStacks(set)) {
                for (int j = 0; j < 18; ++j) {
                    ItemStack pol = this.accessibleInventory.func_70301_a(j);
                    if (pol == null || !StackUtils.isCraftingEquivalent(pol, req, true, true)) continue;
                    ItemStack removed = this.accessibleInventory.func_70298_a(j, req.field_77994_a);
                    req.field_77994_a -= removed.field_77994_a;
                    if (req.func_77973_b().func_77634_r()) {
                        StackUtils.stowContainerItem(removed, this.accessibleInventory, j, player);
                    }
                    if (req.field_77994_a <= 0) continue block1;
                }
            }
        }
    }

    @Override
    public boolean canTakeStack(int slotIndex) {
        return this.validateResources();
    }

    @Override
    public ItemStack takenFromSlot(int slotIndex, boolean consumeRecipe, EntityPlayer player) {
        if (!this.validateResources()) {
            return null;
        }
        if (Proxies.common.isSimulating(this.field_70331_k)) {
            this.memorized.memorizeRecipe(this.field_70331_k, this.currentRecipe);
        }
        this.removeResources(player);
        this.updateCraftResult();
        return this.currentRecipe.func_77571_b().func_77946_l();
    }

    @Override
    public ItemStack getResult() {
        if (this.currentRecipe == null) {
            return null;
        }
        if (this.currentRecipe.func_77571_b() != null) {
            return this.currentRecipe.func_77571_b().func_77946_l();
        }
        return null;
    }

    @Override
    public InventoryAdapter getInternalInventory() {
        return this.accessibleInventory;
    }

    public InventoryAdapter getCraftingInventory() {
        return this.craftingInventory;
    }

    public static class RecipeMemory
    implements INBTTagable,
    IInventory {
        private LinkedList recipes = new LinkedList();
        private long lastUpdate;

        public long getLastUpdate() {
            return this.lastUpdate;
        }

        public Recipe getOrCreateRecipe(World world, InventoryCrafting crafting) {
            Recipe memory = this.getMemorized(crafting, world);
            if (memory != null) {
                return memory;
            }
            return new Recipe(crafting);
        }

        public void memorizeRecipe(World world, Recipe recipe) {
            this.lastUpdate = world.func_82737_E();
            recipe.updateLastUse(world);
            if (this.recipes.contains(recipe)) {
                return;
            }
            if (this.recipes.size() < 8) {
                this.recipes.add(recipe);
                return;
            }
            Recipe oldest = null;
            for (Recipe existing : this.recipes) {
                if (oldest != null && oldest.getLastUsed() < existing.getLastUsed() || existing.isLocked()) continue;
                oldest = existing;
            }
            if (oldest != null) {
                this.recipes.remove(oldest);
                this.recipes.add(recipe);
            }
        }

        public Recipe getRecipe(int recipeIndex) {
            if (this.recipes.size() > recipeIndex) {
                return (Recipe)this.recipes.get(recipeIndex);
            }
            return null;
        }

        public ItemStack getRecipeOutput(int recipeIndex) {
            if (this.recipes.size() > recipeIndex) {
                return ((Recipe)this.recipes.get(recipeIndex)).func_77571_b();
            }
            return null;
        }

        public boolean isLocked(int recipeIndex) {
            if (this.recipes.size() > recipeIndex) {
                return ((Recipe)this.recipes.get(recipeIndex)).isLocked();
            }
            return false;
        }

        public void toggleLock(World world, int recipeIndex) {
            this.lastUpdate = world.func_82737_E();
            if (this.recipes.size() > recipeIndex) {
                ((Recipe)this.recipes.get(recipeIndex)).toogleLock();
            }
        }

        private Recipe getMemorized(InventoryCrafting crafting, World world) {
            for (Recipe recipe : this.recipes) {
                if (!recipe.func_77569_a(crafting, world)) continue;
                return recipe;
            }
            return null;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbttagcompound) {
            this.recipes = new LinkedList();
            if (!nbttagcompound.func_74764_b("RecipeMemory")) {
                return;
            }
            NBTTagList nbttaglist = nbttagcompound.func_74761_m("RecipeMemory");
            for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbttaglist.func_74743_b(j);
                this.recipes.add(new Recipe(nbttagcompound2));
            }
        }

        @Override
        public void writeToNBT(NBTTagCompound nbttagcompound) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.recipes.size(); ++i) {
                if (this.recipes.get(i) == null) continue;
                NBTTagCompound nbttagcompound2 = new NBTTagCompound();
                ((Recipe)this.recipes.get(i)).writeToNBT(nbttagcompound2);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound2);
            }
            nbttagcompound.func_74782_a("RecipeMemory", (NBTBase)nbttaglist);
        }

        public int func_70302_i_() {
            return this.recipes.size();
        }

        public ItemStack func_70301_a(int i) {
            return this.getRecipeOutput(i);
        }

        public ItemStack func_70298_a(int i, int j) {
            return null;
        }

        public ItemStack func_70304_b(int i) {
            return null;
        }

        public void func_70299_a(int i, ItemStack itemstack) {
        }

        public String func_70303_b() {
            return "";
        }

        public boolean func_94042_c() {
            return false;
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(EntityPlayer entityplayer) {
            return true;
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return false;
        }
    }

    public static final class Recipe
    implements IRecipe,
    INBTTagable {
        private InventoryAdapter matrix;
        private long lastUsed;
        private boolean locked;
        private World cachedWorld;
        private IRecipe cachedRecipe;

        public Recipe(InventoryCrafting crafting) {
            this.matrix = new InventoryAdapter(new PlainInventory((IInventory)crafting));
        }

        public Recipe(NBTTagCompound nbttagcompound) {
            this.readFromNBT(nbttagcompound);
        }

        public void setCacheWorld(World world) {
            this.cachedWorld = world;
        }

        private boolean updateCachedIRecipe() {
            if (this.cachedRecipe != null) {
                return true;
            }
            InventoryCrafting crafting = new InventoryCrafting(DUMMY_CONTAINER, 3, 3);
            for (int i = 0; i < crafting.func_70302_i_(); ++i) {
                crafting.func_70299_a(i, this.matrix.func_70301_a(i));
            }
            this.cachedRecipe = RECIPE_BRIDGE.getRecipe(crafting, this.cachedWorld);
            return this.cachedRecipe != null;
        }

        public void updateLastUse(World world) {
            this.lastUsed = world.func_82737_E();
            this.setCacheWorld(world);
        }

        public void toogleLock() {
            this.locked = !this.locked;
        }

        public InventoryAdapter getMatrix() {
            return this.matrix;
        }

        public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
            if (this.updateCachedIRecipe()) {
                return this.cachedRecipe.func_77571_b();
            }
            return null;
        }

        public ItemStack func_77571_b() {
            if (this.updateCachedIRecipe()) {
                return this.cachedRecipe.func_77571_b();
            }
            return null;
        }

        public long getLastUsed() {
            return this.lastUsed;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public int func_77570_a() {
            return this.matrix.func_70302_i_();
        }

        public boolean func_77569_a(InventoryCrafting crafting, World world) {
            if (crafting.func_70302_i_() != this.matrix.func_70302_i_()) {
                return false;
            }
            if (!this.updateCachedIRecipe()) {
                return false;
            }
            return this.cachedRecipe.func_77569_a(crafting, world);
        }

        @Override
        public final void readFromNBT(NBTTagCompound nbttagcompound) {
            this.matrix = new InventoryAdapter((IInventory)new InventoryCrafting(DUMMY_CONTAINER, 3, 3));
            this.matrix.readFromNBT(nbttagcompound);
            this.sanitizeMatrix();
            this.lastUsed = nbttagcompound.func_74763_f("LastUsed");
            this.locked = nbttagcompound.func_74767_n("Locked");
        }

        @Override
        public void writeToNBT(NBTTagCompound nbttagcompound) {
            this.sanitizeMatrix();
            this.matrix.writeToNBT(nbttagcompound);
            nbttagcompound.func_74772_a("LastUsed", this.lastUsed);
            nbttagcompound.func_74757_a("Locked", this.locked);
        }

        private void sanitizeMatrix() {
            for (int slot = 0; slot < this.matrix.func_70302_i_(); ++slot) {
                ItemStack stack = this.matrix.func_70301_a(slot);
                if (stack == null) continue;
                stack.field_77994_a = 1;
            }
        }
    }

    private static class RecipeBridge {
        private LinkedList overrides = new LinkedList();

        private RecipeBridge() {
        }

        public IRecipe getRecipe(InventoryCrafting crafting, World world) {
            for (IRecipe recipe : this.overrides) {
                if (!recipe.func_77569_a(crafting, world)) continue;
                return recipe;
            }
            for (Object obj : CraftingManager.func_77594_a().func_77592_b()) {
                IRecipe recipe = (IRecipe)obj;
                if (!recipe.func_77569_a(crafting, world)) continue;
                return recipe;
            }
            return null;
        }
    }
}

