/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.Vect;
import forestry.farming.logic.CropBlock;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FarmableCocoa
implements IFarmable {
    public static final int COCOA_PLANT_ID = Block.field_72086_bP.field_71990_ca;
    public static final int COCOA_SEED_ID = Item.field_77756_aW.field_77779_bT;
    public static final int COCOA_META = 3;

    @Override
    public boolean isSaplingAt(World world, int x, int y, int z) {
        return world.func_72798_a(x, y, z) == COCOA_PLANT_ID;
    }

    @Override
    public ICrop getCropAt(World world, int x, int y, int z) {
        int blockid = world.func_72798_a(x, y, z);
        if (blockid != COCOA_PLANT_ID) {
            return null;
        }
        int meta = world.func_72805_g(x, y, z);
        if (BlockUtil.getMaturityPod(meta) < 2) {
            return null;
        }
        return new CropBlock(world, blockid, meta, new Vect(x, y, z));
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return itemstack.field_77993_c == COCOA_SEED_ID && itemstack.func_77960_j() == 3;
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean plantSaplingAt(ItemStack germling, World world, int x, int y, int z) {
        return BlockUtil.tryPlantPot(world, x, y, z, COCOA_PLANT_ID);
    }
}

