/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.mail.EnumPostage;
import forestry.api.mail.ILetter;
import forestry.api.mail.IPostalState;
import forestry.api.mail.IStamps;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.MailAddress;
import forestry.api.mail.PostManager;
import forestry.api.mail.TradeStationInfo;
import forestry.core.config.ForestryItem;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.StackUtils;
import forestry.mail.EnumAddressee;
import forestry.mail.EnumDeliveryState;
import forestry.mail.EnumStationState;
import forestry.mail.Letter;
import forestry.mail.items.ItemLetter;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class TradeStation
extends WorldSavedData
implements ITradeStation,
IInventory {
    public static final String SAVE_NAME = "TradePO_";
    public static final short SLOT_SIZE = 39;
    public static final short SLOT_TRADEGOOD = 0;
    public static final short SLOT_EXCHANGE_1 = 1;
    public static final short SLOT_EXCHANGE_COUNT = 4;
    public static final short SLOT_LETTERS_1 = 5;
    public static final short SLOT_LETTERS_COUNT = 6;
    public static final short SLOT_STAMPS_1 = 11;
    public static final short SLOT_STAMPS_COUNT = 4;
    public static final short SLOT_INPUTBUF_1 = 15;
    public static final short SLOT_OUTPUTBUF_1 = 27;
    public static final short SLOT_BUFFER_COUNT = 12;
    private String owner;
    private String moniker;
    private boolean isVirtual = false;
    private boolean isInvalid = false;
    private InventoryAdapter inventory = new InventoryAdapter(39, "INV");

    public TradeStation(String owner, String moniker, boolean isMoniker) {
        super(SAVE_NAME + moniker);
        this.owner = owner;
        this.moniker = moniker;
    }

    public TradeStation(String savename) {
        super(savename);
    }

    @Override
    public String getMoniker() {
        return this.moniker;
    }

    public void func_76184_a(NBTTagCompound nbttagcompound) {
        this.owner = nbttagcompound.func_74779_i("OWN");
        this.moniker = nbttagcompound.func_74779_i("MNK");
        this.isVirtual = nbttagcompound.func_74767_n("VRT");
        this.isInvalid = nbttagcompound.func_74767_n("IVL");
        this.inventory.readFromNBT(nbttagcompound);
    }

    public void func_76187_b(NBTTagCompound nbttagcompound) {
        if (this.owner != null && !this.owner.isEmpty()) {
            nbttagcompound.func_74778_a("OWN", this.owner);
        }
        nbttagcompound.func_74778_a("MNK", this.moniker);
        nbttagcompound.func_74757_a("VRT", this.isVirtual);
        nbttagcompound.func_74757_a("IVL", this.isInvalid);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public boolean isValid() {
        return !this.isInvalid;
    }

    @Override
    public void invalidate() {
        this.isInvalid = true;
    }

    @Override
    public void setVirtual(boolean isVirtual) {
        this.isVirtual = isVirtual;
        this.func_76185_a();
    }

    @Override
    public boolean isVirtual() {
        return this.isVirtual;
    }

    @Override
    public TradeStationInfo getTradeInfo() {
        ItemStack[] condensedRequired = StackUtils.condenseStacks(this.inventory.getStacks(1, 4));
        EnumStationState state = EnumStationState.OK;
        if (!this.isVirtual()) {
            if (!this.hasPaper()) {
                state = EnumStationState.INSUFFICIENT_PAPER;
            }
            if (!this.canPayPostage(2)) {
                state = EnumStationState.INSUFFICIENT_STAMPS;
            }
            if (this.countFillableOrders(1, this.inventory.func_70301_a(0)) <= 0) {
                state = EnumStationState.INSUFFICIENT_TRADE_GOOD;
            }
        }
        return new TradeStationInfo(this.moniker, this.owner, this.inventory.func_70301_a(0), condensedRequired, state);
    }

    @Override
    public IPostalState handleLetter(World world, String recipient, ItemStack letterstack, boolean doLodge) {
        ILetter letter = PostManager.postRegistry.getLetter(letterstack);
        if (!this.isVirtual() && !this.hasPaper()) {
            return EnumStationState.INSUFFICIENT_PAPER;
        }
        int ordersToFill = StackUtils.containsSets(this.inventory.getStacks(1, 4), letter.getAttachments());
        if (ordersToFill <= 0) {
            return EnumStationState.INSUFFICIENT_OFFER;
        }
        if (!this.isVirtual()) {
            int storable;
            int fillable = this.countFillableOrders(ordersToFill, this.inventory.func_70301_a(0));
            if (fillable <= 0) {
                return EnumStationState.INSUFFICIENT_TRADE_GOOD;
            }
            if (fillable < ordersToFill) {
                ordersToFill = fillable;
            }
            if ((storable = this.countStorablePayment(ordersToFill, this.inventory.getStacks(1, 4))) <= 0) {
                return EnumStationState.INSUFFICIENT_BUFFER;
            }
            if (storable < ordersToFill) {
                ordersToFill = storable;
            }
        }
        Letter mail = new Letter(new MailAddress(this.moniker, EnumAddressee.TRADER.toString().toLowerCase(Locale.ENGLISH)), letter.getSender());
        mail.setText("Please find your order attached.");
        for (int i = 0; i < ordersToFill; ++i) {
            mail.addAttachment(this.inventory.func_70301_a(0).func_77946_l());
        }
        mail.addAttachments(this.getSurplusAttachments(ordersToFill, letter.getAttachments()));
        int requiredPostage = mail.requiredPostage();
        if (!this.isVirtual() && !this.canPayPostage(requiredPostage)) {
            return EnumStationState.INSUFFICIENT_STAMPS;
        }
        int[] stampCount = this.getPostage(requiredPostage, this.isVirtual());
        for (int i = 0; i < stampCount.length; ++i) {
            if (stampCount[i] <= 0) continue;
            mail.addStamps(ForestryItem.stamps.getItemStack(stampCount[i], EnumPostage.values()[i].ordinal()));
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        mail.writeToNBT(nbttagcompound);
        ItemStack mailstack = ForestryItem.letters.getItemStack(1, ItemLetter.encodeMeta(1, ItemLetter.getType(mail)));
        mailstack.func_77982_d(nbttagcompound);
        IPostalState responseState = PostManager.postRegistry.getPostOffice(world).lodgeLetter(world, mailstack, doLodge);
        if (!responseState.isOk()) {
            return EnumDeliveryState.RESPONSE_NOT_MAILABLE;
        }
        for (int i = 0; i < ordersToFill; ++i) {
            for (ItemStack stack : this.inventory.getStacks(1, 4)) {
                if (stack == null) continue;
                this.inventory.tryAddStack(stack.func_77946_l(), 27, 12, false);
            }
        }
        this.removePaper();
        this.removeStamps(stampCount);
        this.removeTradegood(ordersToFill);
        this.func_76185_a();
        if (doLodge && this.owner != null && !this.owner.isEmpty()) {
            Letter confirm = new Letter(new MailAddress(this.moniker, EnumAddressee.TRADER.toString().toLowerCase(Locale.ENGLISH)), new MailAddress(this.owner));
            confirm.setText(ordersToFill + " order(s) from " + letter.getSender().getIdentifier() + " were filled.");
            confirm.addStamps(ForestryItem.stamps.getItemStack(1, EnumPostage.P_1.ordinal()));
            nbttagcompound = new NBTTagCompound();
            confirm.writeToNBT(nbttagcompound);
            ItemStack confirmstack = ForestryItem.letters.getItemStack(1, ItemLetter.encodeMeta(1, ItemLetter.getType(confirm)));
            confirmstack.func_77982_d(nbttagcompound);
            PostManager.postRegistry.getPostOffice(world).lodgeLetter(world, confirmstack, doLodge);
        }
        return EnumDeliveryState.OK;
    }

    private int countFillableOrders(int max, ItemStack tradegood) {
        if (tradegood == null) {
            return 0;
        }
        int itemCount = 0;
        for (ItemStack stack : this.inventory.getStacks(15, 12)) {
            if (stack == null || !stack.func_77969_a(tradegood) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)tradegood)) continue;
            itemCount += stack.field_77994_a;
        }
        return (int)Math.floor(itemCount / tradegood.field_77994_a);
    }

    private int countStorablePayment(int max, ItemStack[] exchange) {
        InventoryAdapter test = this.inventory.copy();
        int count = 0;
        for (int i = 0; i < max && test.tryAddStacksCopy(exchange, true); ++i) {
            ++count;
        }
        return count;
    }

    private void removeTradegood(int filled) {
        block0: for (int j = 0; j < filled; ++j) {
            int toRemove = this.inventory.func_70301_a((int)0).field_77994_a;
            for (int i = 15; i < 27; ++i) {
                ItemStack buffer = this.inventory.func_70301_a(i);
                if (buffer == null || !buffer.func_77969_a(this.inventory.func_70301_a(0)) || !ItemStack.func_77970_a((ItemStack)buffer, (ItemStack)this.inventory.func_70301_a(0))) continue;
                ItemStack decrease = this.inventory.func_70298_a(i, toRemove);
                if ((toRemove -= decrease.field_77994_a) <= 0) continue block0;
            }
        }
    }

    private boolean hasPaper() {
        for (ItemStack stack : this.inventory.getStacks(5, 6)) {
            if (stack == null || stack.field_77994_a <= 0) continue;
            return true;
        }
        return false;
    }

    private void removePaper() {
        for (int i = 5; i < 11; ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack == null || stack.field_77993_c != Item.field_77759_aK.field_77779_bT || stack.field_77994_a <= 0) continue;
            this.inventory.func_70298_a(i, 1);
            break;
        }
    }

    private boolean canPayPostage(int postage) {
        int posted = 0;
        for (ItemStack stamp : this.inventory.getStacks(11, 4)) {
            if (stamp == null || !(stamp.func_77973_b() instanceof IStamps) || (posted += ((IStamps)stamp.func_77973_b()).getPostage(stamp).getValue() * stamp.field_77994_a) < postage) continue;
            return true;
        }
        return false;
    }

    private int[] getPostage(int postage, boolean virtual) {
        int[] stamps = new int[EnumPostage.values().length];
        for (int i = EnumPostage.values().length - 1; i > 0 && postage > 0; --i) {
            int max;
            EnumPostage postValue = EnumPostage.values()[i];
            if (postValue.getValue() > postage) continue;
            int num = 99;
            if (!virtual) {
                num = this.getNumStamps(postValue);
            }
            if ((max = (int)Math.floor(postage / postValue.getValue())) < num) {
                num = max;
            }
            stamps[i] = num;
            postage -= num * postValue.getValue();
        }
        return stamps;
    }

    private int getNumStamps(EnumPostage postage) {
        int count = 0;
        for (ItemStack stamp : this.inventory.getStacks(11, 4)) {
            if (stamp == null || !(stamp.func_77973_b() instanceof IStamps) || ((IStamps)stamp.func_77973_b()).getPostage(stamp) != postage) continue;
            count += stamp.field_77994_a;
        }
        return count;
    }

    private void removeStamps(int[] stampCount) {
        for (int i = 1; i < stampCount.length; ++i) {
            if (stampCount[i] <= 0) continue;
            for (int j = 11; j < 15; ++j) {
                ItemStack stamp;
                if (stampCount[i] <= 0 || (stamp = this.inventory.func_70301_a(j)) == null || !(stamp.func_77973_b() instanceof IStamps) || ((IStamps)stamp.func_77973_b()).getPostage(stamp) != EnumPostage.values()[i]) continue;
                ItemStack decrease = this.inventory.func_70298_a(j, stampCount[i]);
                int n = i;
                stampCount[n] = stampCount[n] - decrease.field_77994_a;
            }
        }
    }

    private ItemStack[] getSurplusAttachments(int filled, ItemStack[] attachments) {
        int i;
        ArrayList<ItemStack> surplus = new ArrayList<ItemStack>();
        ItemStack[] pool = new ItemStack[attachments.length];
        for (i = 0; i < attachments.length; ++i) {
            if (attachments[i] == null) continue;
            pool[i] = attachments[i].func_77946_l();
        }
        for (i = 0; i < filled; ++i) {
            ItemStack[] condensedRequired;
            for (ItemStack req : condensedRequired = StackUtils.condenseStacks(this.inventory.getStacks(1, 4))) {
                for (int j = 0; j < pool.length; ++j) {
                    ItemStack pol = pool[j];
                    if (pol == null || !pol.func_77969_a(req)) continue;
                    if (req.field_77994_a >= pol.field_77994_a) {
                        req.field_77994_a -= pol.field_77994_a;
                        pool[j] = null;
                        continue;
                    }
                    pol.field_77994_a -= req.field_77994_a;
                    req.field_77994_a = 0;
                }
            }
        }
        for (ItemStack stack : pool) {
            if (stack == null) continue;
            surplus.add(stack);
        }
        return surplus.toArray(new ItemStack[0]);
    }

    public void func_70296_d() {
        this.func_76185_a();
        this.inventory.func_70296_d();
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.func_76185_a();
        this.inventory.func_70299_a(var1, var2);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int var1) {
        return this.inventory.func_70301_a(var1);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return this.inventory.func_70298_a(var1, var2);
    }

    public ItemStack func_70304_b(int var1) {
        return this.inventory.func_70304_b(var1);
    }

    public String func_70303_b() {
        return this.inventory.func_70303_b();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.inventory.func_70300_a(var1);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }
}

