/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.PluginInfo;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.api.recipes.RecipeManagers;
import forestry.apiculture.CommandBeekeepingMode;
import forestry.apiculture.CommandGiveBee;
import forestry.apiculture.FlowerProviderCacti;
import forestry.apiculture.FlowerProviderEnd;
import forestry.apiculture.FlowerProviderGourd;
import forestry.apiculture.FlowerProviderJungle;
import forestry.apiculture.FlowerProviderMushroom;
import forestry.apiculture.FlowerProviderNetherwart;
import forestry.apiculture.FlowerProviderVanilla;
import forestry.apiculture.FlowerProviderWheat;
import forestry.apiculture.GuiHandlerApiculture;
import forestry.apiculture.PacketHandlerApiculture;
import forestry.apiculture.SaveEventHandlerApiculture;
import forestry.apiculture.VillageHandlerApiculture;
import forestry.apiculture.gadgets.BlockAlveary;
import forestry.apiculture.gadgets.BlockBeehives;
import forestry.apiculture.gadgets.BlockCandle;
import forestry.apiculture.gadgets.BlockStump;
import forestry.apiculture.gadgets.TileAlvearyFan;
import forestry.apiculture.gadgets.TileAlvearyHeater;
import forestry.apiculture.gadgets.TileAlvearyHygroregulator;
import forestry.apiculture.gadgets.TileAlvearyPlain;
import forestry.apiculture.gadgets.TileAlvearySieve;
import forestry.apiculture.gadgets.TileAlvearyStabiliser;
import forestry.apiculture.gadgets.TileAlvearySwarmer;
import forestry.apiculture.gadgets.TileApiaristChest;
import forestry.apiculture.gadgets.TileApiary;
import forestry.apiculture.gadgets.TileBeehouse;
import forestry.apiculture.gadgets.TileCandle;
import forestry.apiculture.gadgets.TileSwarm;
import forestry.apiculture.genetics.AlleleBeeSpecies;
import forestry.apiculture.genetics.AlleleEffectAggressive;
import forestry.apiculture.genetics.AlleleEffectCreeper;
import forestry.apiculture.genetics.AlleleEffectExploration;
import forestry.apiculture.genetics.AlleleEffectGlacial;
import forestry.apiculture.genetics.AlleleEffectHeroic;
import forestry.apiculture.genetics.AlleleEffectIgnition;
import forestry.apiculture.genetics.AlleleEffectMiasmic;
import forestry.apiculture.genetics.AlleleEffectMisanthrope;
import forestry.apiculture.genetics.AlleleEffectNone;
import forestry.apiculture.genetics.AlleleEffectPotion;
import forestry.apiculture.genetics.AlleleEffectRadioactive;
import forestry.apiculture.genetics.AlleleEffectRepulsion;
import forestry.apiculture.genetics.AlleleEffectResurrection;
import forestry.apiculture.genetics.AlleleEffectSnowing;
import forestry.apiculture.genetics.AlleleFlowers;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeHelper;
import forestry.apiculture.genetics.BeeMutation;
import forestry.apiculture.genetics.BeeTemplates;
import forestry.apiculture.genetics.BeekeepingMode;
import forestry.apiculture.genetics.BranchBees;
import forestry.apiculture.genetics.HiveDrop;
import forestry.apiculture.genetics.JubilanceNone;
import forestry.apiculture.genetics.JubilanceProviderHermit;
import forestry.apiculture.genetics.MutationTimeLimited;
import forestry.apiculture.items.ItemAlvearyBlock;
import forestry.apiculture.items.ItemArmorApiarist;
import forestry.apiculture.items.ItemBeeGE;
import forestry.apiculture.items.ItemBeealyzer;
import forestry.apiculture.items.ItemCandleBlock;
import forestry.apiculture.items.ItemHiveFrame;
import forestry.apiculture.items.ItemHoneycomb;
import forestry.apiculture.items.ItemImprinter;
import forestry.apiculture.items.ItemWaxCast;
import forestry.apiculture.proxy.ProxyApiculture;
import forestry.apiculture.trigger.TriggerNoFrames;
import forestry.apiculture.worldgen.HiveDecorator;
import forestry.core.GameMode;
import forestry.core.config.Config;
import forestry.core.config.Configuration;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.config.Property;
import forestry.core.gadgets.BlockBase;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.genetics.Allele;
import forestry.core.interfaces.IOreDictionaryHandler;
import forestry.core.interfaces.IPacketHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.items.ItemCrated;
import forestry.core.items.ItemForestry;
import forestry.core.items.ItemForestryBlock;
import forestry.core.items.ItemOverlay;
import forestry.core.proxy.Proxies;
import forestry.core.triggers.Trigger;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.plugins.NativePlugin;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

@PluginInfo(pluginID="Apiculture", name="Apiculture", author="SirSengir", url="http://forestry.sengir.net/", description="Adds bees, beekeeping and bee products. Affects world generation.")
public class PluginApiculture
extends NativePlugin {
    @SidedProxy(clientSide="forestry.apiculture.proxy.ClientProxyApiculture", serverSide="forestry.apiculture.proxy.ProxyApiculture")
    public static ProxyApiculture proxy;
    private static final String CONFIG_CATEGORY = "apiculture";
    private Configuration apicultureConfig;
    public static String beekeepingMode;
    public static int beeCycleTicks;
    public static boolean apiarySideSensitive;
    public static boolean fancyRenderedBees;
    public static Trigger triggerNoFrames;
    private ArrayList forestDrops;
    private ArrayList meadowsDrops;
    private ArrayList desertDrops;
    private ArrayList jungleDrops;
    private ArrayList endDrops;
    private ArrayList snowDrops;
    private ArrayList swampDrops;
    private ArrayList swarmDrops;
    public static IBeeRoot beeInterface;
    public static MachineDefinition definitionApiary;
    public static MachineDefinition definitionChest;
    public static MachineDefinition definitionBeehouse;

    @Override
    public boolean isAvailable() {
        return !Config.disableApiculture;
    }

    @Override
    public void preInit() {
        super.preInit();
        proxy.addLocalizations();
        this.createHiveDropArrays();
        int blockid = Config.getOrCreateBlockIdProperty(CONFIG_CATEGORY, 1408);
        definitionApiary = new MachineDefinition(blockid, 0, "forestry.Apiary", TileApiary.class, ShapedRecipeCustom.createShapedRecipe(new ItemStack(blockid, 1, 0), new Object[]{"XXX", "#C#", "###", Character.valueOf('X'), "slabWood", Character.valueOf('#'), "plankWood", Character.valueOf('C'), ForestryItem.impregnatedCasing})).setFaces(0, 1, 2, 2, 4, 4, 0, 7);
        definitionBeehouse = new MachineDefinition(blockid, 2, "forestry.Beehouse", TileBeehouse.class, ShapedRecipeCustom.createShapedRecipe(new ItemStack(blockid, 1, 2), "XXX", "#C#", "###", Character.valueOf('X'), "slabWood", Character.valueOf('#'), "plankWood", Character.valueOf('C'), "beeComb")).setFaces(0, 1, 2, 2, 4, 4, 0, 7);
        definitionChest = new MachineDefinition(blockid, 1, "forestry.ApiaristChest", TileApiaristChest.class, ShapedRecipeCustom.createShapedRecipe(new ItemStack(blockid, 1, 1), " # ", "XYX", "XXX", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), "beeComb", Character.valueOf('Y'), Block.field_72077_au)).setFaces(0, 1, 2, 3, 4, 4);
        ForestryBlock.apiculture = new BlockBase(blockid, Material.field_76243_f, definitionApiary, definitionChest, definitionBeehouse).func_71864_b("for.apiculture").func_71849_a(Tabs.tabApiculture);
        Proxies.common.registerBlock(ForestryBlock.apiculture, ItemForestryBlock.class);
        ForestryBlock.beehives = new BlockBeehives(Config.getOrCreateBlockIdProperty("beehives", 1399)).func_71864_b("beehives");
        Proxies.common.registerBlock(ForestryBlock.beehives, ItemForestryBlock.class);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.beehives, (int)0, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.beehives, (int)1, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.beehives, (int)2, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.beehives, (int)3, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.beehives, (int)4, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.beehives, (int)5, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.beehives, (int)6, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.beehives, (int)7, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.beehives, (int)8, (String)"scoop", (int)0);
        beeInterface = BeeManager.beeInterface = new BeeHelper();
        AlleleManager.alleleRegistry.registerSpeciesRoot(BeeManager.beeInterface);
        BeeManager.villageBees = new ArrayList[]{new ArrayList(), new ArrayList()};
        ForestryBlock.candle = new BlockCandle(Config.getOrCreateBlockIdProperty("candle", 1378)).func_71864_b("candle");
        Proxies.common.registerBlock(ForestryBlock.candle, ItemCandleBlock.class);
        ForestryBlock.stump = new BlockStump(Config.getOrCreateBlockIdProperty("stump", 1379)).func_71864_b("stump");
        Proxies.common.registerBlock(ForestryBlock.stump, ItemForestryBlock.class);
        ForestryBlock.alveary = new BlockAlveary(Config.getOrCreateBlockIdProperty("alveary", 1382)).func_71864_b("alveary");
        Proxies.common.registerBlock(ForestryBlock.alveary, ItemAlvearyBlock.class);
        MinecraftForge.setBlockHarvestLevel((Block)ForestryBlock.alveary, (String)"axe", (int)0);
        triggerNoFrames = new TriggerNoFrames(620);
        this.createAlleles();
        VillageHandlerApiculture.registerVillageComponents();
    }

    @Override
    public void doInit() {
        super.doInit();
        this.apicultureConfig = new Configuration();
        Property property = this.apicultureConfig.get("apiary.sidesensitive", CONFIG_CATEGORY, apiarySideSensitive);
        property.Comment = "set to false if apiaries should output all items regardless of side a pipe is attached to";
        apiarySideSensitive = Boolean.parseBoolean(property.Value);
        property = this.apicultureConfig.get("render.bees.fancy", CONFIG_CATEGORY, fancyRenderedBees);
        property.Comment = "set to true to enable a fancy butterfly-like renderer for bees. (experimental!)";
        fancyRenderedBees = Boolean.parseBoolean(property.Value);
        property = this.apicultureConfig.get("beekeeping.mode", CONFIG_CATEGORY, "NORMAL");
        property.Comment = "change beekeeping modes here. possible values EASY, NORMAL, HARD, HARDCORE, INSANE. mods may add additional modes.";
        beekeepingMode = property.Value.trim();
        Proxies.log.finer("Beekeeping mode read from config: " + beekeepingMode);
        property = this.apicultureConfig.get("beekeeping.flowers.custom", CONFIG_CATEGORY, "");
        property.Comment = "add additional flower blocks for apiaries here in the format id:meta. separate blocks using ';'. will be treated like vanilla flowers. not recommended for flowers implemented as tile entities.";
        this.parseAdditionalFlowers(property.Value, FlowerManager.plainFlowers);
        property = this.apicultureConfig.get("species.blacklist", CONFIG_CATEGORY, "");
        property.Comment = "add species to blacklist identified by their uid and seperated with ';'.";
        this.parseBeeBlacklist(property.Value);
        this.apicultureConfig.save();
        this.createMutations();
        this.registerBeehiveDrops();
        beeInterface.registerBeekeepingMode(BeekeepingMode.easy);
        beeInterface.registerBeekeepingMode(BeekeepingMode.normal);
        beeInterface.registerBeekeepingMode(BeekeepingMode.hard);
        beeInterface.registerBeekeepingMode(BeekeepingMode.hardcore);
        beeInterface.registerBeekeepingMode(BeekeepingMode.insane);
        BeeManager.inducers.put(ForestryItem.royalJelly.getItemStack(), 10);
        this.registerTemplates();
        definitionApiary.register();
        definitionBeehouse.register();
        definitionChest.register();
        GameRegistry.registerTileEntity(TileAlvearyPlain.class, (String)"forestry.Alveary");
        GameRegistry.registerTileEntity(TileSwarm.class, (String)"forestry.Swarm");
        GameRegistry.registerTileEntity(TileAlvearySwarmer.class, (String)"forestry.AlvearySwarmer");
        GameRegistry.registerTileEntity(TileAlvearyHeater.class, (String)"forestry.AlvearyHeater");
        GameRegistry.registerTileEntity(TileAlvearyFan.class, (String)"forestry.AlvearyFan");
        GameRegistry.registerTileEntity(TileAlvearyHygroregulator.class, (String)"forestry.AlvearyHygro");
        GameRegistry.registerTileEntity(TileAlvearyStabiliser.class, (String)"forestry.AlvearyStabiliser");
        GameRegistry.registerTileEntity(TileAlvearySieve.class, (String)"forestry.AlvearySieve");
        GameRegistry.registerTileEntity(TileCandle.class, (String)"forestry.Candle");
        BeeManager.villageBees[0].add(beeInterface.templateAsGenome(BeeTemplates.getForestTemplate()));
        BeeManager.villageBees[0].add(beeInterface.templateAsGenome(BeeTemplates.getMeadowsTemplate()));
        BeeManager.villageBees[0].add(beeInterface.templateAsGenome(BeeTemplates.getModestTemplate()));
        BeeManager.villageBees[0].add(beeInterface.templateAsGenome(BeeTemplates.getMarshyTemplate()));
        BeeManager.villageBees[0].add(beeInterface.templateAsGenome(BeeTemplates.getWintryTemplate()));
        BeeManager.villageBees[0].add(beeInterface.templateAsGenome(BeeTemplates.getTropicalTemplate()));
        BeeManager.villageBees[1].add(beeInterface.templateAsGenome(BeeTemplates.getForestRainResistTemplate()));
        BeeManager.villageBees[1].add(beeInterface.templateAsGenome(BeeTemplates.getCommonTemplate()));
        BeeManager.villageBees[1].add(beeInterface.templateAsGenome(BeeTemplates.getValiantTemplate()));
        VillageHandlerApiculture villageHandler = new VillageHandlerApiculture();
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)villageHandler);
        VillagerRegistry.instance().registerVillagerId(80);
        Proxies.render.registerVillagerSkin(80, "textures/entity/beekeeper.png");
        VillagerRegistry.instance().registerVillageTradeHandler(80, (VillagerRegistry.IVillageTradeHandler)villageHandler);
        if (Config.generateBeehives) {
            MinecraftForge.EVENT_BUS.register((Object)HiveDecorator.instance());
        }
        proxy.initializeRendering();
    }

    @Override
    public void postInit() {
        super.postInit();
        this.registerDungeonLoot();
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerApiculture();
    }

    @Override
    public IPacketHandler getPacketHandler() {
        return new PacketHandlerApiculture();
    }

    @Override
    protected void registerItems() {
        ForestryItem.beeQueenGE.registerItem(new ItemBeeGE(Config.getOrCreateItemIdProperty("beeQueenGE", 13083), EnumBeeType.QUEEN), "beeQueenGE");
        ForestryItem.beeDroneGE.registerItem(new ItemBeeGE(Config.getOrCreateItemIdProperty("beeDroneGE", 13084), EnumBeeType.DRONE), "beeDroneGE");
        ForestryItem.beePrincessGE.registerItem(new ItemBeeGE(Config.getOrCreateItemIdProperty("beePrincessGE", 13085), EnumBeeType.PRINCESS), "beePrincessGE");
        ForestryItem.beeLarvaeGE.registerItem(new ItemBeeGE(Config.getOrCreateItemIdProperty("beeLarvaeGE", 13134), EnumBeeType.LARVAE), "beeLarvaeGE");
        ForestryItem.beealyzer.registerItem(new ItemBeealyzer(Config.getOrCreateItemIdProperty("beealyzer", 13086)), "beealyzer");
        ForestryItem.imprinter.registerItem(new ItemImprinter(Config.getOrCreateItemIdProperty("imprinter", 13110)), "imprinter");
        ForestryItem.frameUntreated.registerItem(new ItemHiveFrame(Config.getOrCreateItemIdProperty("frameUntreated", 13125), 80, 0.9f), "frameUntreated");
        ForestryItem.frameImpregnated.registerItem(new ItemHiveFrame(Config.getOrCreateItemIdProperty("frameImpregnated", 13126), 240, 0.4f), "frameImpregnated");
        ForestryItem.frameProven.registerItem(new ItemHiveFrame(Config.getOrCreateItemIdProperty("frameProven", 13127), 720, 0.3f), "frameProven");
        ForestryItem.honeyDrop.registerItem(new ItemOverlay(Config.getOrCreateItemIdProperty("honeyDrop", 13027), Tabs.tabApiculture, new ItemOverlay.OverlayInfo("honey", 15512621, 15255572), new ItemOverlay.OverlayInfo("charged", 0x800505, 10225415).setIsSecret(), new ItemOverlay.OverlayInfo("omega", 0x191919, 4885671).setIsSecret()), "honeyDrop");
        OreDictionary.registerOre((String)"dropHoney", (ItemStack)ForestryItem.honeyDrop.getItemStack());
        ForestryItem.pollen.registerItem(new ItemOverlay(Config.getOrCreateItemIdProperty("pollen", 13030), Tabs.tabApiculture, new ItemOverlay.OverlayInfo("normal", 10652197, 10652197), new ItemOverlay.OverlayInfo("crystalline", 0xFFFFFF, 12975871)), "pollen");
        OreDictionary.registerOre((String)"itemPollen", (ItemStack)ForestryItem.pollen.getItemStack());
        ForestryItem.propolis.registerItem(new ItemOverlay(Config.getOrCreateItemIdProperty("propolis", 13031), Tabs.tabApiculture, new ItemOverlay.OverlayInfo("normal", 12956238), new ItemOverlay.OverlayInfo("sticky", 13012567), new ItemOverlay.OverlayInfo("pulsating", 2936241).setIsSecret(), new ItemOverlay.OverlayInfo("silky", 0xDDFF00)), "propolis");
        ForestryItem.honeydew.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("honeydew", 13033)).func_77637_a(Tabs.tabApiculture), "honeydew");
        OreDictionary.registerOre((String)"dropHoneydew", (ItemStack)ForestryItem.honeydew.getItemStack());
        ForestryItem.royalJelly.registerItem(new ItemForestry(Config.getOrCreateItemIdProperty("royalJelly", 13032)).func_77637_a(Tabs.tabApiculture), "royalJelly");
        OreDictionary.registerOre((String)"dropRoyalJelly", (ItemStack)ForestryItem.royalJelly.getItemStack());
        ForestryItem.waxCast.registerItem(new ItemWaxCast(Config.getOrCreateItemIdProperty("waxCast", 13123)).func_77637_a(Tabs.tabApiculture), "waxCast");
        ForestryItem.beeComb.registerItem(new ItemHoneycomb(Config.getOrCreateItemIdProperty("beeCombs", 13104)), "beeCombs");
        OreDictionary.registerOre((String)"beeComb", (ItemStack)ForestryItem.beeComb.getItemStack(1, Short.MAX_VALUE));
        ForestryItem.apiaristHat.registerItem((Item)new ItemArmorApiarist(Config.getOrCreateItemIdProperty("apiaristHelmet", 13100), 0), "apiaristHelmet");
        ForestryItem.apiaristChest.registerItem((Item)new ItemArmorApiarist(Config.getOrCreateItemIdProperty("apiaristChest", 13101), 1), "apiaristChest");
        ForestryItem.apiaristLegs.registerItem((Item)new ItemArmorApiarist(Config.getOrCreateItemIdProperty("apiaristLegs", 13102), 2), "apiaristLegs");
        ForestryItem.apiaristBoots.registerItem((Item)new ItemArmorApiarist(Config.getOrCreateItemIdProperty("apiaristBoots", 13103), 3), "apiaristBoots");
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerCrates() {
        ForestryItem.cratedBeeswax.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedBeeswax", 13528), ForestryItem.beeswax.getItemStack()), "cratedBeeswax");
        ForestryItem.cratedPollen.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedPollen", 13529), ForestryItem.pollen.getItemStack()), "cratedPollen");
        ForestryItem.cratedPropolis.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedPropolis", 13530), ForestryItem.propolis.getItemStack()), "cratedPropolis");
        ForestryItem.cratedHoneydew.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedHoneydew", 13531), ForestryItem.honeydew.getItemStack()), "cratedHoneydew");
        ForestryItem.cratedRoyalJelly.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedRoyalJelly", 13532), ForestryItem.royalJelly.getItemStack()), "cratedRoyalJelly");
        ForestryItem.cratedHoneycombs.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedHoneycombs", 13527), ForestryItem.beeComb.getItemStack(1, 0)), "cratedHoneycombs");
        ForestryItem.cratedCocoaComb.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedCocoaComb", 13533), ForestryItem.beeComb.getItemStack(1, 1)), "cratedCocoaComb");
        ForestryItem.cratedSimmeringCombs.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedSimmeringCombs", 13545), ForestryItem.beeComb.getItemStack(1, 2)), "cratedSimmeringCombs");
        ForestryItem.cratedStringyCombs.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedStringyCombs", 13546), ForestryItem.beeComb.getItemStack(1, 3)), "cratedStringyCombs");
        ForestryItem.cratedFrozenCombs.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedFrozenCombs", 13547), ForestryItem.beeComb.getItemStack(1, 4)), "cratedFrozenCombs");
        ForestryItem.cratedDrippingCombs.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedDrippingCombs", 13548), ForestryItem.beeComb.getItemStack(1, 5)), "cratedDrippingCombs");
        ForestryItem.cratedRefractoryWax.registerItem(new ItemCrated(Config.getOrCreateItemIdProperty("cratedRefractoryWax", 13549), ForestryItem.refractoryWax.getItemStack()), "cratedRefractoryWax");
    }

    @Override
    protected void registerRecipes() {
        Proxies.common.addRecipe(ForestryItem.apiaristHat.getItemStack(), "###", "# #", Character.valueOf('#'), ForestryItem.craftingMaterial.getItemStack(1, 3));
        Proxies.common.addRecipe(ForestryItem.apiaristChest.getItemStack(), "# #", "###", "###", Character.valueOf('#'), ForestryItem.craftingMaterial.getItemStack(1, 3));
        Proxies.common.addRecipe(ForestryItem.apiaristLegs.getItemStack(), "###", "# #", "# #", Character.valueOf('#'), ForestryItem.craftingMaterial.getItemStack(1, 3));
        Proxies.common.addRecipe(ForestryItem.apiaristBoots.getItemStack(), "# #", "# #", Character.valueOf('#'), ForestryItem.craftingMaterial.getItemStack(1, 3));
        Proxies.common.addRecipe(ForestryItem.vialCatalyst.getItemStack(3), new Object[]{"###", "YXY", Character.valueOf('#'), ForestryItem.waxCapsule, Character.valueOf('X'), Item.field_77755_aX, Character.valueOf('Y'), ForestryItem.pollen});
        Proxies.common.addRecipe(ForestryItem.vialCatalyst.getItemStack(3), new Object[]{"###", "YXY", Character.valueOf('#'), ForestryItem.canEmpty, Character.valueOf('X'), Item.field_77755_aX, Character.valueOf('Y'), ForestryItem.pollen});
        Proxies.common.addRecipe(ForestryItem.vialCatalyst.getItemStack(), new Object[]{"###", "YXY", "###", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('Y'), ForestryItem.fertilizerCompound, Character.valueOf('X'), ForestryItem.waxCapsule});
        Proxies.common.addRecipe(ForestryItem.vialCatalyst.getItemStack(), new Object[]{"###", "YXY", "###", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('Y'), ForestryItem.fertilizerCompound, Character.valueOf('X'), ForestryItem.canEmpty});
        Proxies.common.addRecipe(ForestryItem.vialCatalyst.getItemStack(), new Object[]{"###", "YXY", "###", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('Y'), ForestryItem.pollen, Character.valueOf('X'), ForestryItem.waxCapsule});
        Proxies.common.addRecipe(ForestryItem.vialCatalyst.getItemStack(), new Object[]{"###", "YXY", "###", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('Y'), ForestryItem.pollen, Character.valueOf('X'), ForestryItem.canEmpty});
        Proxies.common.addRecipe(ForestryItem.scoop.getItemStack(1), "#X#", "###", " # ", Character.valueOf('#'), "stickWood", Character.valueOf('X'), Block.field_72101_ab);
        Proxies.common.addRecipe(new ItemStack(Item.field_77761_aM), new Object[]{"#X#", "#X#", "#X#", Character.valueOf('#'), ForestryItem.propolis, Character.valueOf('X'), ForestryItem.pollen});
        Proxies.common.addRecipe(new ItemStack(Item.field_77813_bB), new Object[]{"#X#", "#Y#", "#X#", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('X'), ForestryItem.honeydew, Character.valueOf('Y'), Item.field_77738_bf});
        Proxies.common.addRecipe(ForestryItem.frameUntreated.getItemStack(), "###", "#S#", "###", Character.valueOf('#'), "stickWood", Character.valueOf('S'), Item.field_77683_K);
        Proxies.common.addRecipe(ForestryItem.frameImpregnated.getItemStack(), new Object[]{"###", "#S#", "###", Character.valueOf('#'), ForestryItem.stickImpregnated, Character.valueOf('S'), Item.field_77683_K});
        if (ForestryItem.honeyedSlice != null) {
            Proxies.common.addRecipe(ForestryItem.honeyedSlice.getItemStack(4), new Object[]{"###", "#X#", "###", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('X'), Item.field_77684_U});
        }
        if (ForestryItem.honeyPot != null) {
            Proxies.common.addRecipe(ForestryItem.honeyPot.getItemStack(1), new Object[]{"# #", " X ", "# #", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('X'), ForestryItem.waxCapsule});
        }
        if (ForestryItem.ambrosia != null) {
            Proxies.common.addRecipe(ForestryItem.ambrosia.getItemStack(), new Object[]{"#Y#", "XXX", "###", Character.valueOf('#'), ForestryItem.honeydew, Character.valueOf('X'), ForestryItem.royalJelly, Character.valueOf('Y'), ForestryItem.waxCapsule});
        }
        Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.capsule"), new Object[]{"###", Character.valueOf('#'), ForestryItem.beeswax});
        Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.refractory"), new Object[]{"###", Character.valueOf('#'), ForestryItem.refractoryWax});
        Proxies.common.addRecipe(ForestryItem.bituminousPeat.getItemStack(), new Object[]{" # ", "XYX", " # ", Character.valueOf('#'), "dustAsh", Character.valueOf('X'), ForestryItem.peat, Character.valueOf('Y'), ForestryItem.propolis});
        Proxies.common.addRecipe(new ItemStack(Block.field_72069_aq, 3), new Object[]{" # ", " # ", " Y ", Character.valueOf('#'), ForestryItem.beeswax, Character.valueOf('Y'), "stickWood"});
        Proxies.common.addRecipe(ForestryItem.craftingMaterial.getItemStack(1, 1), "# #", " # ", "# #", Character.valueOf('#'), ForestryItem.propolis.getItemStack(1, 2));
        RecipeManagers.carpenterManager.addRecipe(30, LiquidHelper.getLiquid("water", 600), null, new ItemStack(ForestryBlock.candle, 24), new Object[]{" X ", "###", "###", Character.valueOf('#'), ForestryItem.beeswax, Character.valueOf('X'), Item.field_77683_K});
        RecipeManagers.carpenterManager.addRecipe(10, LiquidHelper.getLiquid("water", 200), null, new ItemStack(ForestryBlock.candle, 6), new Object[]{"#X#", Character.valueOf('#'), ForestryItem.beeswax, Character.valueOf('X'), ForestryItem.craftingMaterial.getItemStack(1, 2)});
        Proxies.common.addShapelessRecipe(new ItemStack(ForestryBlock.candle), new ItemStack(ForestryBlock.candle));
        Proxies.common.addShapelessRecipe(new ItemStack(ForestryBlock.candle, 1, 1), new ItemStack(ForestryBlock.candle, 1, 1));
        Proxies.common.addRecipe(ForestryItem.waxCast.getItemStack(), new Object[]{"###", "# #", "###", Character.valueOf('#'), ForestryItem.beeswax});
        Proxies.common.addRecipe(new ItemStack(ForestryBlock.alveary), new Object[]{"###", "#X#", "###", Character.valueOf('X'), ForestryItem.impregnatedCasing, Character.valueOf('#'), ForestryItem.craftingMaterial.getItemStack(1, 6)});
        Proxies.common.addRecipe(new ItemStack(ForestryBlock.alveary, 1, 2), "#G#", " X ", "#G#", Character.valueOf('#'), ForestryItem.tubes.getItemStack(1, 5), Character.valueOf('X'), ForestryBlock.alveary, Character.valueOf('G'), Item.field_77717_p);
        Proxies.common.addRecipe(new ItemStack(ForestryBlock.alveary, 1, 3), "I I", " X ", "I#I", Character.valueOf('#'), ForestryItem.tubes.getItemStack(1, 4), Character.valueOf('X'), ForestryBlock.alveary, Character.valueOf('I'), Item.field_77703_o);
        Proxies.common.addRecipe(new ItemStack(ForestryBlock.alveary, 1, 4), "#I#", " X ", "YYY", Character.valueOf('#'), ForestryItem.tubes.getItemStack(1, 4), Character.valueOf('X'), ForestryBlock.alveary, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('Y'), Block.field_71981_t);
        Proxies.common.addRecipe(new ItemStack(ForestryBlock.alveary, 1, 5), "GIG", "GXG", "GIG", Character.valueOf('X'), ForestryBlock.alveary, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('G'), Block.field_71946_M);
        Proxies.common.addRecipe(new ItemStack(ForestryBlock.alveary, 1, 6), "G G", "GXG", "G G", Character.valueOf('X'), ForestryBlock.alveary, Character.valueOf('G'), Item.field_94583_ca);
        Proxies.common.addRecipe(new ItemStack(ForestryBlock.alveary, 1, 7), "III", " X ", "WWW", Character.valueOf('X'), ForestryBlock.alveary, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('W'), ForestryItem.craftingMaterial.getItemStack(1, 3));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ForestryItem.honeyDrop.getItemStack()}, LiquidHelper.getLiquid("honey", 100), ForestryItem.propolis.getItemStack(), 5);
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ForestryItem.honeydew.getItemStack()}, LiquidHelper.getLiquid("honey", 100));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ForestryItem.phosphor.getItemStack(2), new ItemStack(Block.field_71939_E)}, LiquidHelper.getLiquid("lava", 2000));
        RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ForestryItem.phosphor.getItemStack(2), new ItemStack(Block.field_71979_v)}, LiquidHelper.getLiquid("lava", 1600));
        RecipeManagers.carpenterManager.addRecipe(100, LiquidHelper.getLiquid("water", 2000), null, ForestryItem.beealyzer.getItemStack(), new Object[]{"X#X", "X#X", "RDR", Character.valueOf('#'), Block.field_72003_bq, Character.valueOf('X'), "ingotTin", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('D'), Item.field_77702_n});
        RecipeManagers.carpenterManager.addRecipe(50, LiquidHelper.getLiquid("honey", 500), null, ForestryItem.craftingMaterial.getItemStack(1, 6), new Object[]{" J ", "###", "WPW", Character.valueOf('#'), "plankWood", Character.valueOf('J'), ForestryItem.royalJelly, Character.valueOf('W'), ForestryItem.beeswax, Character.valueOf('P'), ForestryItem.pollen});
        RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 0), ForestryItem.beeswax.getItemStack(), ForestryItem.honeyDrop.getItemStack(), 90);
        RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 1), ForestryItem.beeswax.getItemStack(), new ItemStack(Item.field_77756_aW, 1, 3), 50);
        RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 2), ForestryItem.refractoryWax.getItemStack(), ForestryItem.phosphor.getItemStack(2), 70);
        RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 3), ForestryItem.propolis.getItemStack(), ForestryItem.honeyDrop.getItemStack(), 40);
        RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 5), ForestryItem.honeydew.getItemStack(), ForestryItem.honeyDrop.getItemStack(), 40);
        RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 4), new ItemStack[]{ForestryItem.beeswax.getItemStack(), ForestryItem.honeyDrop.getItemStack(), new ItemStack(Item.field_77768_aD), ForestryItem.pollen.getItemStack(1, 1)}, new int[]{80, 70, 40, 20});
        RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 6), ForestryItem.honeyDrop.getItemStack(), ForestryItem.propolis.getItemStack(1, 3), 80);
        RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 7), ForestryItem.beeswax.getItemStack(), ForestryItem.honeyDrop.getItemStack(), 90);
        RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 8), new ItemStack[]{ForestryItem.honeyDrop.getItemStack(), ForestryItem.propolis.getItemStack(1, 2)}, new int[]{40, 100});
        RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 9), new ItemStack[0], new int[0]);
        RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 10), new ItemStack[]{ForestryItem.honeyDrop.getItemStack(), ForestryItem.beeswax.getItemStack(), new ItemStack(Item.field_77677_M)}, new int[]{20, 20, 90});
        RecipeManagers.centrifugeManager.addRecipe(80, ForestryItem.beeComb.getItemStack(1, 11), new ItemStack[]{ForestryItem.honeyDrop.getItemStack(2, 1)}, new int[]{100});
        RecipeManagers.centrifugeManager.addRecipe(80, ForestryItem.beeComb.getItemStack(1, 12), new ItemStack[]{ForestryItem.honeyDrop.getItemStack(1, 1)}, new int[]{100});
        RecipeManagers.centrifugeManager.addRecipe(400, ForestryItem.beeComb.getItemStack(1, 13), new ItemStack[]{ForestryItem.honeyDrop.getItemStack(1, 2)}, new int[]{100});
        RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 14), new ItemStack[]{ForestryItem.honeyDrop.getItemStack(), ForestryItem.beeswax.getItemStack(), new ItemStack(Item.field_77685_T)}, new int[]{20, 20, 80});
        RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 15), ForestryItem.beeswax.getItemStack(), ForestryItem.honeyDrop.getItemStack(), 90);
        RecipeManagers.centrifugeManager.addRecipe(20, ForestryItem.beeComb.getItemStack(1, 16), new ItemStack[]{ForestryItem.honeydew.getItemStack(), ForestryItem.beeswax.getItemStack(), new ItemStack(Item.field_94583_ca)}, new int[]{60, 20, 30});
        RecipeManagers.centrifugeManager.addRecipe(5, ForestryItem.propolis.getItemStack(1, 3), new ItemStack[]{ForestryItem.craftingMaterial.getItemStack(1, 2), ForestryItem.propolis.getItemStack()}, new int[]{60, 10});
        RecipeManagers.fermenterManager.addRecipe(ForestryItem.honeydew.getItemStack(), 500, 1.0f, LiquidHelper.getLiquid("short.mead", 1), LiquidHelper.getLiquid("honey", 1));
    }

    private void registerBeehiveDrops() {
        this.forestDrops.add(new HiveDrop(BeeTemplates.getForestTemplate(), new ItemStack[]{ForestryItem.beeComb.getItemStack(1, 0)}, 80).setIgnobleShare(0.7f));
        this.forestDrops.add(new HiveDrop(BeeTemplates.getForestRainResistTemplate(), new ItemStack[]{ForestryItem.beeComb.getItemStack(1, 0)}, 8));
        this.forestDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), new ItemStack[]{ForestryItem.beeComb.getItemStack(1, 0)}, 3));
        this.meadowsDrops.add(new HiveDrop(BeeTemplates.getMeadowsTemplate(), new ItemStack[]{ForestryItem.beeComb.getItemStack(1, 0)}, 80).setIgnobleShare(0.7f));
        this.meadowsDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), new ItemStack[]{ForestryItem.beeComb.getItemStack(1, 0)}, 3));
        this.desertDrops.add(new HiveDrop(BeeTemplates.getModestTemplate(), new ItemStack[]{ForestryItem.beeComb.getItemStack(1, 7)}, 80).setIgnobleShare(0.7f));
        this.desertDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), new ItemStack[]{ForestryItem.beeComb.getItemStack(1, 7)}, 3));
        this.jungleDrops.add(new HiveDrop(BeeTemplates.getTropicalTemplate(), new ItemStack[]{ForestryItem.beeComb.getItemStack(1, 6)}, 80).setIgnobleShare(0.7f));
        this.jungleDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), new ItemStack[]{ForestryItem.beeComb.getItemStack(1, 6)}, 3));
        this.endDrops.add(new HiveDrop(BeeTemplates.getEnderTemplate(), new ItemStack[]{ForestryItem.beeComb.getItemStack(1, 8)}, 90));
        this.snowDrops.add(new HiveDrop(BeeTemplates.getWintryTemplate(), new ItemStack[]{ForestryItem.beeComb.getItemStack(1, 4)}, 80).setIgnobleShare(0.5f));
        this.snowDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), new ItemStack[]{ForestryItem.beeComb.getItemStack(1, 4)}, 3));
        this.swampDrops.add(new HiveDrop(BeeTemplates.getMarshyTemplate(), new ItemStack[]{ForestryItem.beeComb.getItemStack(1, 15)}, 80).setIgnobleShare(0.4f));
        this.swampDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), new ItemStack[]{ForestryItem.beeComb.getItemStack(1, 15)}, 3));
    }

    private void registerDungeonLoot() {
        int rarity = Config.dungeonLootRare ? 5 : 10;
        ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(this.getBeeItemFromTemplate(BeeTemplates.getSteadfastTemplate(), EnumBeeType.DRONE), 1, 1, rarity));
        ItemStack stack = new ItemStack(ForestryBlock.candle);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("colour", 0xFFFFFF);
        stack.func_77982_d(tag);
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(stack, 7, 12, 12));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(ForestryItem.scoop.getItemStack(), 1, 1, 8));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(ForestryItem.propolis.getItemStack(), 2, 4, 6));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(ForestryItem.beeComb.getItemStack(), 4, 12, 7));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(ForestryItem.beeComb.getItemStack(1, 4), 2, 10, 7));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(ForestryItem.beeComb.getItemStack(1, 6), 1, 6, 7));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(this.getBeeItemFromTemplate(BeeTemplates.getForestRainResistTemplate(), EnumBeeType.PRINCESS), 1, 1, 5));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(this.getBeeItemFromTemplate(BeeTemplates.getCommonTemplate(), EnumBeeType.DRONE), 1, 2, 8));
        ChestGenHooks.addItem((String)"naturalistChest", (WeightedRandomChestContent)new WeightedRandomChestContent(this.getBeeItemFromTemplate(BeeTemplates.getMeadowsTemplate(), EnumBeeType.PRINCESS), 1, 1, 5));
    }

    private ItemStack getBeeItemFromTemplate(IAllele[] template, EnumBeeType beeType) {
        ItemStack beeItem;
        Bee bee = new Bee(beeInterface.templateAsGenome(template));
        switch (beeType) {
            default: {
                beeItem = ForestryItem.beeDroneGE.getItemStack();
                break;
            }
            case PRINCESS: {
                beeItem = ForestryItem.beePrincessGE.getItemStack();
            }
        }
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        bee.writeToNBT(nbtTagCompound);
        beeItem.func_77982_d(nbtTagCompound);
        return beeItem;
    }

    private void createHiveDropArrays() {
        BeeManager.hiveDrops = new ArrayList[8];
        this.forestDrops = new ArrayList();
        BeeManager.hiveDrops[0] = this.forestDrops;
        this.meadowsDrops = new ArrayList();
        BeeManager.hiveDrops[1] = this.meadowsDrops;
        this.desertDrops = new ArrayList();
        BeeManager.hiveDrops[2] = this.desertDrops;
        this.jungleDrops = new ArrayList();
        BeeManager.hiveDrops[3] = this.jungleDrops;
        this.endDrops = new ArrayList();
        BeeManager.hiveDrops[4] = this.endDrops;
        this.snowDrops = new ArrayList();
        BeeManager.hiveDrops[5] = this.snowDrops;
        this.swampDrops = new ArrayList();
        BeeManager.hiveDrops[6] = this.swampDrops;
        this.swarmDrops = new ArrayList();
        BeeManager.hiveDrops[7] = this.swarmDrops;
    }

    private void createAlleles() {
        IClassification hymnoptera = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.ORDER, "hymnoptera", "Hymnoptera");
        AlleleManager.alleleRegistry.getClassification("class.insecta").addMemberGroup(hymnoptera);
        IClassification apidae = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.FAMILY, "apidae", "Apidae");
        hymnoptera.addMemberGroup(apidae);
        BranchBees honey = new BranchBees("honey", "Apis");
        apidae.addMemberGroup(honey);
        BranchBees noble = new BranchBees("noble", "Probapis");
        apidae.addMemberGroup(noble);
        BranchBees industrious = new BranchBees("industrious", "Industrapis");
        apidae.addMemberGroup(industrious);
        BranchBees heroic = new BranchBees("heroic", "Herapis");
        apidae.addMemberGroup(heroic);
        BranchBees infernal = new BranchBees("infernal", "Diapis");
        apidae.addMemberGroup(infernal);
        BranchBees austere = new BranchBees("austere", "Modapis");
        apidae.addMemberGroup(austere);
        BranchBees end = new BranchBees("end", "Finapis");
        apidae.addMemberGroup(end);
        BranchBees vengeful = new BranchBees("vengeful", "Punapis");
        apidae.addMemberGroup(vengeful);
        BranchBees tropical = new BranchBees("tropical", "Caldapis");
        apidae.addMemberGroup(tropical);
        BranchBees frozen = new BranchBees("frozen", "Coagapis");
        apidae.addMemberGroup(frozen);
        BranchBees reddened = new BranchBees("reddened", "Rubapis");
        apidae.addMemberGroup(reddened);
        BranchBees festive = new BranchBees("festive", "Festapis");
        apidae.addMemberGroup(festive);
        BranchBees agrarian = new BranchBees("agrarian", "Rustapis");
        apidae.addMemberGroup(agrarian);
        BranchBees boggy = new BranchBees("boggy", "Paludapis");
        apidae.addMemberGroup(boggy);
        BranchBees monastic = new BranchBees("monastic", "Monapis");
        apidae.addMemberGroup(monastic);
        Allele.speciesForest = new AlleleBeeSpecies("speciesForest", true, "bees.species.forest", honey, "nigrocincta", 1691884, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 0), 30);
        Allele.speciesMeadows = new AlleleBeeSpecies("speciesMeadows", true, "bees.species.meadows", honey, "florea", 15667998, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 0), 30);
        Allele.speciesCommon = new AlleleBeeSpecies("speciesCommon", true, "bees.species.common", honey, "cerana", 0xB2B2B2, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 0), 35).setIsSecret();
        Allele.speciesCultivated = new AlleleBeeSpecies("speciesCultivated", true, "bees.species.cultivated", honey, "mellifera", 5715180, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 0), 40).setIsSecret();
        Allele.speciesNoble = new AlleleBeeSpecies("speciesNoble", false, "bees.species.noble", noble, "nobilis", 15505945, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 5), 20).setIsSecret();
        Allele.speciesMajestic = new AlleleBeeSpecies("speciesMajestic", true, "bees.species.majestic", noble, "regalis", 0x7F0000, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 5), 30).setIsSecret();
        Allele.speciesImperial = new AlleleBeeSpecies("speciesImperial", false, "bees.species.imperial", noble, "imperatorius", 10739759, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 5), 20).addProduct(ForestryItem.royalJelly.getItemStack(), 15).setHasEffect().setIsSecret();
        Allele.speciesDiligent = new AlleleBeeSpecies("speciesDiligent", false, "bees.species.diligent", industrious, "sedulus", 12720620, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 3), 20).setIsSecret();
        Allele.speciesUnweary = new AlleleBeeSpecies("speciesUnweary", true, "bees.species.unweary", industrious, "assiduus", 1698906, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 3), 30).setIsSecret();
        Allele.speciesIndustrious = new AlleleBeeSpecies("speciesIndustrious", false, "bees.species.industrious", industrious, "industria", 0xFFFFFF, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 3), 20).addProduct(ForestryItem.pollen.getItemStack(), 15).setHasEffect().setIsSecret();
        Allele.speciesSteadfast = new AlleleBeeSpecies("speciesSteadfast", false, "bees.species.steadfast", heroic, "legio", 5057301, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 1), 20).setIsSecret().setHasEffect();
        Allele.speciesValiant = new AlleleBeeSpecies("speciesValiant", true, "bees.species.valiant", heroic, "centurio", 6450141, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 1), 30).addSpecialty(new ItemStack(Item.field_77747_aY), 15).setIsSecret();
        Allele.speciesHeroic = new AlleleBeeSpecies("speciesHeroic", false, "bees.species.heroic", heroic, "kraphti", 11785700, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 1), 40).setIsSecret().setHasEffect();
        Allele.speciesSinister = new AlleleBeeSpecies("speciesSinister", false, "bees.species.sinister", infernal, "caecus", 11785700, 10101539).addProduct(ForestryItem.beeComb.getItemStack(1, 2), 45).setEntityTexture("sinisterBee").setIsSecret().setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        Allele.speciesFiendish = new AlleleBeeSpecies("speciesFiendish", true, "bees.species.fiendish", infernal, "diabolus", 14139109, 10101539).addProduct(ForestryItem.beeComb.getItemStack(1, 2), 55).addProduct(ForestryItem.ash.getItemStack(), 15).setEntityTexture("sinisterBee").setIsSecret().setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        Allele.speciesDemonic = new AlleleBeeSpecies("speciesDemonic", false, "bees.species.demonic", infernal, "draco", 16049152, 10101539).addProduct(ForestryItem.beeComb.getItemStack(1, 2), 45).addProduct(new ItemStack(Item.field_77751_aT), 15).setEntityTexture("sinisterBee").setHasEffect().setIsSecret().setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        Allele.speciesModest = new AlleleBeeSpecies("speciesModest", false, "bees.species.modest", austere, "modicus", 12959366, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 7), 20).setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        Allele.speciesFrugal = new AlleleBeeSpecies("speciesFrugal", true, "bees.species.frugal", austere, "permodestus", 15260849, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 7), 30).setIsSecret().setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        Allele.speciesAustere = new AlleleBeeSpecies("speciesAustere", false, "bees.species.austere", austere, "correpere", 16775874, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 7), 20).addSpecialty(ForestryItem.beeComb.getItemStack(1, 10), 50).setHasEffect().setIsSecret().setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        Allele.speciesTropical = new AlleleBeeSpecies("speciesTropical", false, "bees.species.tropical", tropical, "mendelia", 3637280, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 6), 20).setEntityTexture("tropicalBee").setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        Allele.speciesExotic = new AlleleBeeSpecies("speciesExotic", true, "bees.species.exotic", tropical, "darwini", 3164419, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 6), 30).setEntityTexture("tropicalBee").setIsSecret().setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        Allele.speciesEdenic = new AlleleBeeSpecies("speciesEdenic", false, "bees.species.edenic", tropical, "humboldti", 3751181, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 6), 20).setEntityTexture("tropicalBee").setHasEffect().setIsSecret().setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        Allele.speciesEnded = new AlleleBeeSpecies("speciesEnded", false, "bees.species.ender", end, "notchi", 14711290, 0xD9DE9E).addProduct(ForestryItem.beeComb.getItemStack(1, 8), 30).setEntityTexture("endBee").setIsSecret().setTemperature(EnumTemperature.COLD);
        Allele.speciesSpectral = new AlleleBeeSpecies("speciesSpectral", true, "bees.species.spectral", end, "idolum", 11111405, 0xD9DE9E).addProduct(ForestryItem.beeComb.getItemStack(1, 8), 50).setEntityTexture("endBee").setIsSecret().setTemperature(EnumTemperature.COLD);
        Allele.speciesPhantasmal = new AlleleBeeSpecies("speciesPhantasmal", false, "bees.species.phantasmal", end, "lemur", 13369594, 0xD9DE9E).addProduct(ForestryItem.beeComb.getItemStack(1, 8), 40).setEntityTexture("endBee").setIsSecret().setHasEffect().setTemperature(EnumTemperature.COLD);
        Allele.speciesWintry = new AlleleBeeSpecies("speciesWintry", false, "bees.species.wintry", frozen, "brumalis", 10551240, 14349811).addProduct(ForestryItem.beeComb.getItemStack(1, 4), 30).setEntityTexture("icyBee").setTemperature(EnumTemperature.ICY);
        Allele.speciesIcy = new AlleleBeeSpecies("speciesIcy", true, "bees.species.icy", frozen, "coagulis", 0xA0FFFF, 14349811).addProduct(ForestryItem.beeComb.getItemStack(1, 4), 20).setEntityTexture("icyBee").addProduct(ForestryItem.craftingMaterial.getItemStack(1, 5), 20).setTemperature(EnumTemperature.ICY).setIsSecret();
        Allele.speciesGlacial = new AlleleBeeSpecies("speciesGlacial", false, "bees.species.glacial", frozen, "glacialis", 0xEFFFFF, 14349811).addProduct(ForestryItem.beeComb.getItemStack(1, 4), 20).setEntityTexture("icyBee").addProduct(ForestryItem.craftingMaterial.getItemStack(1, 5), 40).setTemperature(EnumTemperature.ICY).setHasEffect().setIsSecret();
        Allele.speciesVindictive = new AlleleBeeSpecies("speciesVindictive", false, "bees.species.vindictive", vengeful, "ultio", 15400947, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 9), 25).setIsSecret().setIsNotCounted();
        Allele.speciesVengeful = new AlleleBeeSpecies("speciesVengeful", false, "bees.species.vengeful", vengeful, "punire", 12770816, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 9), 40).setIsSecret().setIsNotCounted();
        Allele.speciesAvenging = new AlleleBeeSpecies("speciesAvenging", false, "bees.species.avenging", vengeful, "hostimentum", 0xDDFF00, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 9), 40).setIsSecret().setHasEffect().setIsNotCounted();
        Allele.speciesDarkened = new AlleleBeeSpecies("speciesDarkened", false, "bees.species.darkened", reddened, "pahimas", 14139109, 2494249).addProduct(ForestryItem.beeComb.getItemStack(1, 0), 100).addSpecialty(ForestryItem.beeComb.getItemStack(1, 12), 100).setJubilanceProvider(new JubilanceNone()).setIsSecret().setIsNotCounted();
        AlleleManager.alleleRegistry.blacklistAllele(Allele.speciesDarkened.getUID());
        Allele.speciesReddened = new AlleleBeeSpecies("speciesReddened", false, "bees.species.reddened", reddened, "xenophos", 16302529, 2494249).addProduct(ForestryItem.beeComb.getItemStack(1, 0), 100).addSpecialty(ForestryItem.beeComb.getItemStack(1, 11), 100).setJubilanceProvider(new JubilanceNone()).setIsSecret().setIsNotCounted();
        AlleleManager.alleleRegistry.blacklistAllele(Allele.speciesReddened.getUID());
        Allele.speciesOmega = new AlleleBeeSpecies("speciesOmega", false, "bees.species.omega", reddened, "slopokis", 0xFEFF8F, 2494249).addProduct(ForestryItem.beeComb.getItemStack(1, 0), 100).addSpecialty(ForestryItem.beeComb.getItemStack(1, 13), 100).setJubilanceProvider(new JubilanceNone()).setIsSecret().setIsNotCounted();
        AlleleManager.alleleRegistry.blacklistAllele(Allele.speciesOmega.getUID());
        Allele.speciesLeporine = new AlleleBeeSpecies("speciesLeporine", false, "bees.species.leporine", festive, "lepus", 0xFEFF8F, 3987287).addProduct(ForestryItem.beeComb.getItemStack(1, 6), 30).addProduct(new ItemStack(Item.field_77764_aP), 10).setIsSecret().setIsNotCounted().setHasEffect();
        Allele.speciesMerry = new AlleleBeeSpecies("speciesMerry", false, "bees.species.merry", festive, "feliciter", 0xFFFFFF, 0xD40000).addProduct(ForestryItem.beeComb.getItemStack(1, 4), 30).addProduct(ForestryItem.craftingMaterial.getItemStack(1, 5), 20).setTemperature(EnumTemperature.ICY).setIsSecret().setIsNotCounted().setHasEffect();
        Allele.speciesTipsy = new AlleleBeeSpecies("speciesTipsy", false, "bees.species.tipsy", festive, "ebrius", 0xFFFFFF, 12720620).addProduct(ForestryItem.beeComb.getItemStack(1, 4), 30).addProduct(ForestryItem.craftingMaterial.getItemStack(1, 5), 20).setTemperature(EnumTemperature.ICY).setIsSecret().setIsNotCounted().setHasEffect();
        Allele.speciesTricky = new AlleleBeeSpecies("speciesTricky", false, "bees.species.tricky", festive, "libita", 4800827, 16738816).addProduct(ForestryItem.beeComb.getItemStack(1, 0), 40).addProduct(new ItemStack(Item.field_77743_bc), 15).addSpecialty(new ItemStack(Item.field_82799_bQ, 1, 0), 2).addSpecialty(new ItemStack(Item.field_82799_bQ, 1, 2), 2).addSpecialty(new ItemStack(Item.field_82799_bQ, 1, 3), 2).addSpecialty(new ItemStack(Item.field_82799_bQ, 1, 4), 2).setIsSecret().setIsNotCounted().setHasEffect();
        Allele.speciesRural = new AlleleBeeSpecies("speciesRural", false, "bees.species.rural", agrarian, "rustico", 0xFEFF8F, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 14), 20).setIsSecret();
        Allele.speciesMarshy = new AlleleBeeSpecies("speciesMarshy", true, "bees.species.marshy", boggy, "adorasti", 5531174, 16768022).addProduct(ForestryItem.beeComb.getItemStack(1, 15), 30).setHumidity(EnumHumidity.DAMP);
        Allele.speciesMonastic = new AlleleBeeSpecies("speciesMonastic", false, "bees.species.monastic", monastic, "monachus", 4339484, 16775094).addProduct(ForestryItem.beeComb.getItemStack(1, 14), 30).addSpecialty(ForestryItem.beeComb.getItemStack(1, 16), 10).setJubilanceProvider(new JubilanceProviderHermit()).setIsSecret();
        Allele.speciesSecluded = new AlleleBeeSpecies("speciesSecluded", true, "bees.species.secluded", monastic, "contractus", 8087092, 16775094).addSpecialty(ForestryItem.beeComb.getItemStack(1, 16), 20).setJubilanceProvider(new JubilanceProviderHermit()).setIsSecret();
        Allele.speciesHermitic = new AlleleBeeSpecies("speciesHermitic", false, "bees.species.hermitic", monastic, "anachoreta", 16766060, 16775094).addSpecialty(ForestryItem.beeComb.getItemStack(1, 16), 20).setJubilanceProvider(new JubilanceProviderHermit()).setHasEffect().setIsSecret();
        Allele.flowersVanilla = new AlleleFlowers("flowersVanilla", new FlowerProviderVanilla(), true);
        Allele.flowersNether = new AlleleFlowers("flowersNether", new FlowerProviderNetherwart());
        Allele.flowersCacti = new AlleleFlowers("flowersCacti", new FlowerProviderCacti());
        Allele.flowersMushrooms = new AlleleFlowers("flowersMushrooms", new FlowerProviderMushroom());
        Allele.flowersEnd = new AlleleFlowers("flowersEnd", new FlowerProviderEnd());
        Allele.flowersJungle = new AlleleFlowers("flowersJungle", new FlowerProviderJungle());
        Allele.flowersSnow = new AlleleFlowers("flowersSnow", new FlowerProviderVanilla(), true);
        Allele.flowersWheat = new AlleleFlowers("flowersWheat", new FlowerProviderWheat(), true);
        Allele.flowersGourd = new AlleleFlowers("flowersGourd", new FlowerProviderGourd(), true);
        Allele.effectNone = new AlleleEffectNone("effectNone");
        Allele.effectAggressive = new AlleleEffectAggressive("effectAggressive");
        Allele.effectHeroic = new AlleleEffectHeroic("effectHeroic");
        Allele.effectBeatific = new AlleleEffectPotion("effectBeatific", "beatific", false, Potion.field_76428_l, 100, true);
        Allele.effectMiasmic = new AlleleEffectMiasmic("effectMiasmic");
        Allele.effectMisanthrope = new AlleleEffectMisanthrope("effectMisanthrope");
        Allele.effectGlacial = new AlleleEffectGlacial("effectGlacial");
        Allele.effectRadioactive = new AlleleEffectRadioactive("effectRadioactive");
        Allele.effectCreeper = new AlleleEffectCreeper("effectCreeper");
        Allele.effectIgnition = new AlleleEffectIgnition("effectIgnition");
        Allele.effectExploration = new AlleleEffectExploration("effectExploration");
        Allele.effectFestiveEaster = new AlleleEffectNone("effectFestiveEaster");
        Allele.effectSnowing = new AlleleEffectSnowing("effectSnowing");
        Allele.effectDrunkard = new AlleleEffectPotion("effectDrunkard", "drunkard", false, Potion.field_76431_k, 100, false);
        Allele.effectReanimation = new AlleleEffectResurrection("effectReanimation", "reanimation", AlleleEffectResurrection.getReanimationList());
        Allele.effectResurrection = new AlleleEffectResurrection("effectResurrection", "resurrection", AlleleEffectResurrection.getResurrectionList());
        Allele.effectRepulsion = new AlleleEffectRepulsion("effectRepulsion");
    }

    private void createMutations() {
        BeeTemplates.commonA = new BeeMutation(Allele.speciesForest, Allele.speciesMeadows, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonB = new BeeMutation(Allele.speciesModest, Allele.speciesForest, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonC = new BeeMutation(Allele.speciesModest, Allele.speciesMeadows, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonD = new BeeMutation(Allele.speciesWintry, Allele.speciesForest, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonE = new BeeMutation(Allele.speciesWintry, Allele.speciesMeadows, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonF = new BeeMutation(Allele.speciesWintry, Allele.speciesModest, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonG = new BeeMutation(Allele.speciesTropical, Allele.speciesForest, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonH = new BeeMutation(Allele.speciesTropical, Allele.speciesMeadows, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonI = new BeeMutation(Allele.speciesTropical, Allele.speciesModest, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonJ = new BeeMutation(Allele.speciesTropical, Allele.speciesWintry, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonK = new BeeMutation(Allele.speciesMarshy, Allele.speciesForest, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonL = new BeeMutation(Allele.speciesMarshy, Allele.speciesMeadows, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonM = new BeeMutation(Allele.speciesMarshy, Allele.speciesModest, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonN = new BeeMutation(Allele.speciesMarshy, Allele.speciesWintry, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonO = new BeeMutation(Allele.speciesMarshy, Allele.speciesTropical, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.cultivatedA = new BeeMutation(Allele.speciesCommon, Allele.speciesForest, BeeTemplates.getCultivatedTemplate(), 12);
        BeeTemplates.cultivatedB = new BeeMutation(Allele.speciesCommon, Allele.speciesMeadows, BeeTemplates.getCultivatedTemplate(), 12);
        BeeTemplates.cultivatedC = new BeeMutation(Allele.speciesCommon, Allele.speciesModest, BeeTemplates.getCultivatedTemplate(), 12);
        BeeTemplates.cultivatedD = new BeeMutation(Allele.speciesCommon, Allele.speciesWintry, BeeTemplates.getCultivatedTemplate(), 12);
        BeeTemplates.cultivatedE = new BeeMutation(Allele.speciesCommon, Allele.speciesTropical, BeeTemplates.getCultivatedTemplate(), 12);
        BeeTemplates.cultivatedF = new BeeMutation(Allele.speciesCommon, Allele.speciesMarshy, BeeTemplates.getCultivatedTemplate(), 12);
        BeeTemplates.nobleA = new BeeMutation(Allele.speciesCommon, Allele.speciesCultivated, BeeTemplates.getNobleTemplate(), 10);
        BeeTemplates.majesticA = new BeeMutation(Allele.speciesNoble, Allele.speciesCultivated, BeeTemplates.getMajesticTemplate(), 8);
        BeeTemplates.imperialA = new BeeMutation(Allele.speciesNoble, Allele.speciesMajestic, BeeTemplates.getImperialTemplate(), 8);
        BeeTemplates.diligentA = new BeeMutation(Allele.speciesCommon, Allele.speciesCultivated, BeeTemplates.getDiligentTemplate(), 10);
        BeeTemplates.unwearyA = new BeeMutation(Allele.speciesDiligent, Allele.speciesCultivated, BeeTemplates.getUnwearyTemplate(), 8);
        BeeTemplates.industriousA = new BeeMutation(Allele.speciesDiligent, Allele.speciesUnweary, BeeTemplates.getIndustriousTemplate(), 8);
        BeeTemplates.heroicA = new BeeMutation(Allele.speciesSteadfast, Allele.speciesValiant, BeeTemplates.getHeroicTemplate(), 6).restrictBiomeType(BiomeDictionary.Type.FOREST).enableStrictBiomeCheck();
        BeeTemplates.sinisterA = new BeeMutation(Allele.speciesModest, Allele.speciesCultivated, BeeTemplates.getSinisterTemplate(), 60).restrictBiomeType(BiomeDictionary.Type.NETHER);
        BeeTemplates.sinisterB = new BeeMutation(Allele.speciesTropical, Allele.speciesCultivated, BeeTemplates.getSinisterTemplate(), 60).restrictBiomeType(BiomeDictionary.Type.NETHER);
        BeeTemplates.fiendishA = new BeeMutation(Allele.speciesSinister, Allele.speciesCultivated, BeeTemplates.getFiendishTemplate(), 40).restrictBiomeType(BiomeDictionary.Type.NETHER);
        BeeTemplates.fiendishB = new BeeMutation(Allele.speciesSinister, Allele.speciesModest, BeeTemplates.getFiendishTemplate(), 40).restrictBiomeType(BiomeDictionary.Type.NETHER);
        BeeTemplates.fiendishC = new BeeMutation(Allele.speciesSinister, Allele.speciesTropical, BeeTemplates.getFiendishTemplate(), 40).restrictBiomeType(BiomeDictionary.Type.NETHER);
        BeeTemplates.demonicA = new BeeMutation(Allele.speciesSinister, Allele.speciesFiendish, BeeTemplates.getDemonicTemplate(), 25).restrictBiomeType(BiomeDictionary.Type.NETHER);
        BeeTemplates.frugalA = new BeeMutation(Allele.speciesModest, Allele.speciesSinister, BeeTemplates.getFrugalTemplate(), 16).setTemperatureRainfall(1.9f, 2.0f, 0.0f, 0.1f);
        BeeTemplates.frugalB = new BeeMutation(Allele.speciesModest, Allele.speciesFiendish, BeeTemplates.getFrugalTemplate(), 10).setTemperatureRainfall(1.9f, 2.0f, 0.0f, 0.1f);
        BeeTemplates.austereA = new BeeMutation(Allele.speciesModest, Allele.speciesFrugal, BeeTemplates.getAustereTemplate(), 8).setTemperatureRainfall(1.9f, 2.0f, 0.0f, 0.1f);
        BeeTemplates.exoticA = new BeeMutation(Allele.speciesAustere, Allele.speciesTropical, BeeTemplates.getExoticTemplate(), 12);
        BeeTemplates.edenicA = new BeeMutation(Allele.speciesExotic, Allele.speciesTropical, BeeTemplates.getEdenicTemplate(), 8);
        BeeTemplates.icyA = new BeeMutation(Allele.speciesIndustrious, Allele.speciesWintry, BeeTemplates.getIcyTemplate(), 12).setTemperature(0.0f, 0.15f);
        BeeTemplates.glacialA = new BeeMutation(Allele.speciesIcy, Allele.speciesWintry, BeeTemplates.getGlacialTemplate(), 8).setTemperature(0.0f, 0.15f);
        BeeTemplates.leporineA = new MutationTimeLimited(Allele.speciesMeadows, Allele.speciesForest, BeeTemplates.getLeporineTemplate(), 10, new MutationTimeLimited.DayMonth(29, 3), new MutationTimeLimited.DayMonth(15, 4)).setIsSecret();
        BeeTemplates.merryA = new MutationTimeLimited(Allele.speciesWintry, Allele.speciesForest, BeeTemplates.getMerryTemplate(), 10, new MutationTimeLimited.DayMonth(21, 12), new MutationTimeLimited.DayMonth(27, 12)).setIsSecret();
        BeeTemplates.tipsyA = new MutationTimeLimited(Allele.speciesWintry, Allele.speciesMeadows, BeeTemplates.getTipsyTemplate(), 10, new MutationTimeLimited.DayMonth(27, 12), new MutationTimeLimited.DayMonth(2, 1)).setIsSecret();
        BeeTemplates.trickyA = new MutationTimeLimited(Allele.speciesSinister, Allele.speciesCommon, BeeTemplates.getTrickyTemplate(), 10, new MutationTimeLimited.DayMonth(15, 10), new MutationTimeLimited.DayMonth(3, 11)).setIsSecret();
        BeeTemplates.ruralA = new BeeMutation(Allele.speciesMeadows, Allele.speciesDiligent, BeeTemplates.getRuralTemplate(), 12).restrictBiomeType(BiomeDictionary.Type.PLAINS).enableStrictBiomeCheck();
        BeeTemplates.secludedA = new BeeMutation(Allele.speciesMonastic, Allele.speciesAustere, BeeTemplates.getSecludedTemplate(), 12);
        BeeTemplates.hermiticA = new BeeMutation(Allele.speciesMonastic, Allele.speciesSecluded, BeeTemplates.getHermiticTemplate(), 8);
        BeeTemplates.spectralA = new BeeMutation(Allele.speciesHermitic, Allele.speciesEnded, BeeTemplates.getSpectralTemplate(), 4);
        BeeTemplates.phantasmalA = new BeeMutation(Allele.speciesSpectral, Allele.speciesEnded, BeeTemplates.getPhantasmalTemplate(), 2);
        BeeTemplates.vindictiveA = new BeeMutation(Allele.speciesMonastic, Allele.speciesDemonic, BeeTemplates.getVindictiveTemplate(), 4).setIsSecret();
        BeeTemplates.vengefulA = new BeeMutation(Allele.speciesDemonic, Allele.speciesVindictive, BeeTemplates.getVengefulTemplate(), 8).setIsSecret();
        BeeTemplates.vengefulB = new BeeMutation(Allele.speciesMonastic, Allele.speciesVindictive, BeeTemplates.getVengefulTemplate(), 8).setIsSecret();
        BeeTemplates.avengingA = new BeeMutation(Allele.speciesVengeful, Allele.speciesVindictive, BeeTemplates.getAvengingTemplate(), 4);
    }

    private void registerTemplates() {
        beeInterface.registerTemplate(BeeTemplates.getForestTemplate());
        beeInterface.registerTemplate(BeeTemplates.getMeadowsTemplate());
        beeInterface.registerTemplate(BeeTemplates.getCommonTemplate());
        beeInterface.registerTemplate(BeeTemplates.getCultivatedTemplate());
        beeInterface.registerTemplate(BeeTemplates.getNobleTemplate());
        beeInterface.registerTemplate(BeeTemplates.getMajesticTemplate());
        beeInterface.registerTemplate(BeeTemplates.getImperialTemplate());
        beeInterface.registerTemplate(BeeTemplates.getDiligentTemplate());
        beeInterface.registerTemplate(BeeTemplates.getUnwearyTemplate());
        beeInterface.registerTemplate(BeeTemplates.getIndustriousTemplate());
        beeInterface.registerTemplate(BeeTemplates.getSteadfastTemplate());
        beeInterface.registerTemplate(BeeTemplates.getValiantTemplate());
        beeInterface.registerTemplate(BeeTemplates.getHeroicTemplate());
        beeInterface.registerTemplate(BeeTemplates.getSinisterTemplate());
        beeInterface.registerTemplate(BeeTemplates.getFiendishTemplate());
        beeInterface.registerTemplate(BeeTemplates.getDemonicTemplate());
        beeInterface.registerTemplate(BeeTemplates.getModestTemplate());
        beeInterface.registerTemplate(BeeTemplates.getFrugalTemplate());
        beeInterface.registerTemplate(BeeTemplates.getAustereTemplate());
        beeInterface.registerTemplate(BeeTemplates.getTropicalTemplate());
        beeInterface.registerTemplate(BeeTemplates.getExoticTemplate());
        beeInterface.registerTemplate(BeeTemplates.getEdenicTemplate());
        beeInterface.registerTemplate(BeeTemplates.getWintryTemplate());
        beeInterface.registerTemplate(BeeTemplates.getIcyTemplate());
        beeInterface.registerTemplate(BeeTemplates.getGlacialTemplate());
        beeInterface.registerTemplate(BeeTemplates.getVindictiveTemplate());
        beeInterface.registerTemplate(BeeTemplates.getVengefulTemplate());
        beeInterface.registerTemplate(BeeTemplates.getAvengingTemplate());
        beeInterface.registerTemplate(BeeTemplates.getDarkenedTemplate());
        beeInterface.registerTemplate(BeeTemplates.getReddenedTemplate());
        beeInterface.registerTemplate(BeeTemplates.getOmegaTemplate());
        beeInterface.registerTemplate(BeeTemplates.getRuralTemplate());
        beeInterface.registerTemplate(BeeTemplates.getLeporineTemplate());
        beeInterface.registerTemplate(BeeTemplates.getMerryTemplate());
        beeInterface.registerTemplate(BeeTemplates.getTipsyTemplate());
        beeInterface.registerTemplate(BeeTemplates.getTrickyTemplate());
        beeInterface.registerTemplate(BeeTemplates.getMarshyTemplate());
        beeInterface.registerTemplate(BeeTemplates.getMonasticTemplate());
        beeInterface.registerTemplate(BeeTemplates.getSecludedTemplate());
        beeInterface.registerTemplate(BeeTemplates.getHermiticTemplate());
        beeInterface.registerTemplate(BeeTemplates.getEnderTemplate());
        beeInterface.registerTemplate(BeeTemplates.getSpectralTemplate());
        beeInterface.registerTemplate(BeeTemplates.getPhantasmalTemplate());
    }

    private void parseAdditionalFlowers(String list, ArrayList target) {
        String[] items;
        for (String item : items = list.split("[;]+")) {
            if (item.isEmpty()) continue;
            String[] ident = item.split("[:]+");
            int id = 0;
            int meta = 0;
            if (ident.length > 1) {
                id = Integer.parseInt(ident[0]);
                meta = Integer.parseInt(ident[1]);
            } else {
                id = Integer.parseInt(ident[0]);
            }
            if (id <= 0) continue;
            if (id < Block.field_71973_m.length && Block.field_71973_m[id] != null || Item.field_77698_e[id] != null) {
                Proxies.log.finer("Adding flower of (" + id + ":" + meta + ") to vanilla flower provider.");
                target.add(new ItemStack(id, 1, meta));
                continue;
            }
            Proxies.log.warning("Failed to add flower of (" + id + ":" + meta + ") to vanilla flower provider since it was null.");
        }
    }

    private void parseBeeBlacklist(String list) {
        String[] items;
        for (String item : items = list.split("[;]+")) {
            if (item.isEmpty()) continue;
            FMLCommonHandler.instance().getFMLLogger().finer("Blacklisting bee species identified by " + item);
            AlleleManager.alleleRegistry.blacklistAllele(item);
        }
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerApiculture();
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }

    @Override
    public ICommand[] getConsoleCommands() {
        return new ICommand[]{new CommandBeekeepingMode(), new CommandGiveBee(EnumBeeType.DRONE), new CommandGiveBee(EnumBeeType.PRINCESS), new CommandGiveBee(EnumBeeType.QUEEN)};
    }

    @Override
    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equals("add-candle-lighting-id")) {
            ItemStack value = message.getItemStackValue();
            if (value != null) {
                ((BlockCandle)ForestryBlock.candle).addIDToLightingList(value.field_77993_c);
            } else {
                Logger.getLogger("Forestry").log(Level.WARNING, "Recieved an invalid 'add-candle-lighting-id' request from mod %s. Please contact the author and report this issue.", message.getSender());
            }
            return true;
        }
        return super.processIMCMessage(message);
    }

    static {
        beekeepingMode = "NORMAL";
        beeCycleTicks = 550;
        apiarySideSensitive = false;
        fancyRenderedBees = false;
    }
}

