/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import buildcraft.api.fuels.IronEngineCoolant;
import buildcraft.api.fuels.IronEngineFuel;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.ITriggerProvider;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.recipes.RefineryRecipes;
import buildcraft.api.transport.IPipe;
import forestry.api.core.IPlugin;
import forestry.api.core.PluginInfo;
import forestry.core.GameMode;
import forestry.core.config.Config;
import forestry.core.config.Configuration;
import forestry.core.config.ForestryItem;
import forestry.core.config.Property;
import forestry.core.gadgets.TileForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.LiquidHelper;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

@PluginInfo(pluginID="BC3", name="BuildCraft 3", author="SirSengir", url="http://forestry.sengir.net/", description="Compatibility plugin for BuildCraft 3.")
public class PluginBuildCraft
implements IPlugin,
ITriggerProvider {
    public static PluginBuildCraft instance;
    public static Configuration config;
    public static boolean ignore;
    public static Item wrench;
    public static Item stoneGear;
    public static Item pipeWaterproof;

    public PluginBuildCraft() {
        if (instance == null) {
            instance = this;
        }
    }

    @Override
    public boolean isAvailable() {
        return Proxies.common.isModLoaded("BuildCraft|Core") && Proxies.common.isModLoaded("BuildCraft|Transport");
    }

    @Override
    public void doInit() {
        config = Config.config;
        Property buildcraftignore = config.get("buildcraft.ignore", "common", false);
        buildcraftignore.Comment = "set to true to ignore buildcraft";
        ignore = Boolean.parseBoolean(buildcraftignore.Value);
        IronEngineCoolant.addCoolant(LiquidHelper.getLiquid("ice", 1).getFluid(), 10.0f);
        this.addIronEngineFuel(LiquidHelper.getLiquid("bioethanol", 1).getFluid(), 4.0f, 15000.0f * GameMode.getGameMode().getFloatSetting("fuel.ethanol.combustion"));
        this.addRefineryRecipe(LiquidHelper.getLiquid("biomass", 4), null, LiquidHelper.getLiquid("bioethanol", 1), 10, 1);
        ActionManager.registerTriggerProvider(this);
        this.initStoneGear();
        this.initWaterproof();
        this.initLiquids();
    }

    @Override
    public void postInit() {
    }

    private void initLiquids() {
        LiquidHelper.injectWaxContainer("oil", 1000, ForestryItem.waxCapsuleOil.getItemStack(), ForestryItem.waxCapsule.getItemStack());
        LiquidHelper.injectWaxContainer("fuel", 1000, ForestryItem.waxCapsuleFuel.getItemStack(), ForestryItem.waxCapsule.getItemStack());
        LiquidHelper.injectRefractoryContainer("oil", 1000, ForestryItem.refractoryOil.getItemStack(), ForestryItem.refractoryEmpty.getItemStack());
        LiquidHelper.injectRefractoryContainer("fuel", 1000, ForestryItem.refractoryFuel.getItemStack(), ForestryItem.refractoryEmpty.getItemStack());
        LiquidHelper.injectTinContainer("oil", 1000, ForestryItem.canOil.getItemStack(), ForestryItem.canEmpty.getItemStack());
        LiquidHelper.injectTinContainer("fuel", 1000, ForestryItem.canFuel.getItemStack(), ForestryItem.canEmpty.getItemStack());
    }

    private void addIronEngineFuel(Fluid fuel, float powerPerCycle, float totalBurningTime) {
        IronEngineFuel.addFuel(fuel, (float)((int)powerPerCycle), (int)totalBurningTime);
    }

    private void addRefineryRecipe(FluidStack ingredient1, FluidStack ingredient2, FluidStack result, int energy, int delay) {
        RefineryRecipes.addRecipe(ingredient1, ingredient2, result, energy, delay);
    }

    private void initStoneGear() {
        try {
            stoneGear = (Item)Class.forName("buildcraft.BuildCraftCore").getField("stoneGearItem").get(null);
        }
        catch (Exception ex) {
            Proxies.log.fine("No BuildCraft stone gear found.");
            return;
        }
    }

    private void initWaterproof() {
        try {
            pipeWaterproof = (Item)Class.forName("buildcraft.BuildCraftTransport").getField("pipeWaterproof").get(null);
        }
        catch (Exception ex) {
            Proxies.log.fine("No BuildCraft pipe waterproof found.");
            return;
        }
        Proxies.common.addRecipe(new ItemStack(pipeWaterproof), new Object[]{"#", Character.valueOf('#'), ForestryItem.beeswax});
    }

    public float invokeUseEnergyMethod(PowerHandler workProvider, float min, float max, boolean doUse) {
        return workProvider.useEnergy(min, max, doUse);
    }

    public void invokeReceiveEnergyMethod(PowerHandler.Type type, PowerHandler.PowerReceiver receiver, float quantity, ForgeDirection from) {
        receiver.receiveEnergy(type, quantity, from);
    }

    @Override
    public LinkedList getPipeTriggers(IPipe pipe) {
        return null;
    }

    @Override
    public LinkedList getNeighborTriggers(Block block, TileEntity tile) {
        if (tile instanceof TileForestry) {
            return ((TileForestry)tile).getCustomTriggers();
        }
        return null;
    }

    @Override
    public void preInit() {
    }
}

