/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.LaserKind;
import buildcraft.api.filler.FillerManager;
import buildcraft.api.filler.IFillerPattern;
import buildcraft.api.filler.IPatternIterator;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionReceptor;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.builders.TileMarker;
import buildcraft.builders.filler.pattern.PatternFill;
import buildcraft.builders.triggers.ActionFiller;
import buildcraft.core.Box;
import buildcraft.core.IMachine;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.network.IGuiReturnHandler;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketPayloadStream;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.triggers.ActionMachineControl;
import buildcraft.core.utils.Utils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public class TileFiller
extends TileBuildCraft
implements IInventory,
IPowerReceptor,
IMachine,
IActionReceptor,
IGuiReturnHandler {
    public IFillerPattern currentPattern = PatternFill.INSTANCE;
    private static int POWER_USAGE = 25;
    private final Box box = new Box();
    private boolean done = false;
    private IPatternIterator patternIterator;
    private PowerHandler powerHandler;
    private ActionMachineControl.Mode lastMode = ActionMachineControl.Mode.Unknown;
    private SimpleInventory inv = new SimpleInventory(27, "Filler", 64);

    public TileFiller() {
        this.inv.addListener(this);
        this.powerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE);
        this.initPowerProvider();
    }

    private void initPowerProvider() {
        this.powerHandler.configure(30.0f, POWER_USAGE * 2, POWER_USAGE, POWER_USAGE * 4);
        this.powerHandler.configurePowerPerdition(1, 1);
    }

    @Override
    public void initialize() {
        IAreaProvider a;
        super.initialize();
        if (!CoreProxy.proxy.isRenderWorld(this.field_70331_k) && (a = Utils.getNearbyAreaProvider(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n)) != null) {
            this.box.initialize(a);
            if (a instanceof TileMarker) {
                ((TileMarker)a).removeFromWorld();
            }
            if (!CoreProxy.proxy.isRenderWorld(this.field_70331_k) && this.box.isInitialized()) {
                this.box.createLasers(this.field_70331_k, LaserKind.Stripes);
            }
            this.sendNetworkUpdate();
        }
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.done && this.lastMode == ActionMachineControl.Mode.Loop) {
            this.done = false;
        }
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        if (CoreProxy.proxy.isRenderWorld(this.field_70331_k)) {
            return;
        }
        if (this.done) {
            return;
        }
        if (this.lastMode == ActionMachineControl.Mode.Off) {
            return;
        }
        if (this.powerHandler.useEnergy(POWER_USAGE, POWER_USAGE, false) != (float)POWER_USAGE) {
            return;
        }
        if (!this.box.isInitialized()) {
            return;
        }
        if (this.patternIterator == null) {
            this.patternIterator = this.currentPattern.createPatternIterator(this, this.box, ForgeDirection.NORTH);
        }
        ItemStack stackToUse = null;
        int slotNum = 0;
        for (InventoryIterator.IInvSlot slot : InventoryIterator.getIterable(this.inv, ForgeDirection.UNKNOWN)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || stack.field_77994_a <= 0) continue;
            stackToUse = stack;
            slotNum = slot.getIndex();
            break;
        }
        this.done = this.patternIterator.iteratePattern(stackToUse);
        this.powerHandler.useEnergy(POWER_USAGE, POWER_USAGE, true);
        if (stackToUse != null && stackToUse.field_77994_a <= 0) {
            this.func_70299_a(slotNum, null);
        }
        if (this.done) {
            this.patternIterator = null;
            this.sendNetworkUpdate();
        } else if (this.powerHandler.getEnergyStored() >= (float)POWER_USAGE) {
            this.doWork(workProvider);
        }
    }

    public final int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inv.func_70298_a(slot, amount);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv.func_70299_a(slot, stack);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inv.func_70304_b(slot);
    }

    public String func_70303_b() {
        return "Filler";
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.inv.readFromNBT(nbt);
        if (nbt.func_74764_b("pattern")) {
            this.currentPattern = FillerManager.registry.getPattern(nbt.func_74779_i("pattern"));
        }
        if (this.currentPattern == null) {
            this.currentPattern = PatternFill.INSTANCE;
        }
        if (nbt.func_74764_b("box")) {
            this.box.initialize(nbt.func_74775_l("box"));
        }
        this.done = nbt.func_74767_n("done");
        this.lastMode = ActionMachineControl.Mode.values()[nbt.func_74771_c("lastMode")];
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        this.inv.writeToNBT(nbt);
        if (this.currentPattern != null) {
            nbt.func_74778_a("pattern", this.currentPattern.getUniqueTag());
        }
        NBTTagCompound boxStore = new NBTTagCompound();
        this.box.writeToNBT(boxStore);
        nbt.func_74782_a("box", (NBTBase)boxStore);
        nbt.func_74757_a("done", this.done);
        nbt.func_74774_a("lastMode", (byte)this.lastMode.ordinal());
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        this.destroy();
    }

    @Override
    public void destroy() {
        this.box.deleteLasers();
    }

    public void setPattern(IFillerPattern pattern) {
        if (pattern != null && this.currentPattern != pattern) {
            this.currentPattern = pattern;
            this.patternIterator = null;
            this.done = false;
            this.sendNetworkUpdate();
        }
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayloadStream payload = new PacketPayloadStream(new PacketPayloadStream.StreamWriter(){

            @Override
            public void writeData(DataOutputStream data) throws IOException {
                TileFiller.this.box.writeToStream(data);
                data.writeBoolean(TileFiller.this.done);
                data.writeUTF(TileFiller.this.currentPattern.getUniqueTag());
            }
        });
        return payload;
    }

    public void handlePacketPayload(DataInputStream data) throws IOException {
        boolean initialized = this.box.isInitialized();
        this.box.readFromStream(data);
        this.done = data.readBoolean();
        this.setPattern(FillerManager.registry.getPattern(data.readUTF()));
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (!initialized && this.box.isInitialized()) {
            this.box.createLasers(this.field_70331_k, LaserKind.Stripes);
        }
    }

    @Override
    public void handleDescriptionPacket(PacketUpdate packet) throws IOException {
        this.handlePacketPayload(((PacketPayloadStream)packet.payload).stream);
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) throws IOException {
        this.handlePacketPayload(((PacketPayloadStream)packet.payload).stream);
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public boolean isActive() {
        return !this.done && this.lastMode != ActionMachineControl.Mode.Off;
    }

    @Override
    public boolean manageFluids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void actionActivated(IAction action) {
        if (action == BuildCraftCore.actionOn) {
            this.lastMode = ActionMachineControl.Mode.On;
        } else if (action == BuildCraftCore.actionOff) {
            this.lastMode = ActionMachineControl.Mode.Off;
        } else if (action == BuildCraftCore.actionLoop) {
            this.lastMode = ActionMachineControl.Mode.Loop;
        } else if (action instanceof ActionFiller) {
            ActionFiller actFill = (ActionFiller)action;
            this.setPattern(actFill.pattern);
        }
    }

    @Override
    public boolean allowAction(IAction action) {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeUTF(this.currentPattern.getUniqueTag());
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer player) throws IOException {
        this.setPattern(FillerManager.registry.getPattern(data.readUTF()));
    }
}

