/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.BuildCraftEnergy;
import buildcraft.api.gates.IOverrideDefaultTriggers;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.DefaultProps;
import buildcraft.core.TileBuffer;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.network.TileNetworkData;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.energy.gui.ContainerEngine;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileEngine
extends TileBuildCraft
implements IPowerReceptor,
IPowerEmitter,
IOverrideDefaultTriggers,
IPipeConnection {
    public static final ResourceLocation WOOD_TEXTURE = new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/base_wood.png");
    public static final ResourceLocation STONE_TEXTURE = new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/base_stone.png");
    public static final ResourceLocation IRON_TEXTURE = new ResourceLocation(DefaultProps.TEXTURE_PATH_BLOCKS + "/base_iron.png");
    public static final float MIN_HEAT = 20.0f;
    public static final float IDEAL_HEAT = 100.0f;
    public static final float MAX_HEAT = 250.0f;
    protected int progressPart = 0;
    protected boolean lastPower = false;
    protected PowerHandler powerHandler;
    public float currentOutput = 0.0f;
    public boolean isRedstonePowered = false;
    private boolean checkOrienation = false;
    private TileBuffer[] tileCache;
    public float progress;
    public float energy;
    public float heat = 20.0f;
    @TileNetworkData
    public EnergyStage energyStage = EnergyStage.BLUE;
    @TileNetworkData
    public ForgeDirection orientation = ForgeDirection.UP;
    @TileNetworkData
    public boolean isPumping = false;

    public TileEngine() {
        this.powerHandler = new PowerHandler(this, PowerHandler.Type.ENGINE);
        this.powerHandler.configurePowerPerdition(1, 100);
    }

    @Override
    public void initialize() {
        if (!CoreProxy.proxy.isRenderWorld(this.field_70331_k)) {
            this.powerHandler.configure(this.minEnergyReceived(), this.maxEnergyReceived(), 1.0f, this.getMaxEnergy());
            this.checkRedstonePower();
        }
    }

    public abstract ResourceLocation getTextureFile();

    public boolean onBlockActivated(EntityPlayer player, ForgeDirection side) {
        return false;
    }

    public float getEnergyLevel() {
        return this.energy / this.getMaxEnergy();
    }

    protected EnergyStage computeEnergyStage() {
        float energyLevel = this.getHeatLevel();
        if (energyLevel < 0.25f) {
            return EnergyStage.BLUE;
        }
        if (energyLevel < 0.5f) {
            return EnergyStage.GREEN;
        }
        if (energyLevel < 0.75f) {
            return EnergyStage.YELLOW;
        }
        if (energyLevel < 1.0f) {
            return EnergyStage.RED;
        }
        return EnergyStage.OVERHEAT;
    }

    public final EnergyStage getEnergyStage() {
        if (CoreProxy.proxy.isSimulating(this.field_70331_k)) {
            if (this.energyStage == EnergyStage.OVERHEAT) {
                return this.energyStage;
            }
            EnergyStage newStage = this.computeEnergyStage();
            if (this.energyStage != newStage) {
                this.energyStage = newStage;
                this.sendNetworkUpdate();
            }
        }
        return this.energyStage;
    }

    public void updateHeatLevel() {
        this.heat = 230.0f * this.getEnergyLevel() + 20.0f;
    }

    public float getHeatLevel() {
        return (this.heat - 20.0f) / 230.0f;
    }

    public float getIdealHeatLevel() {
        return this.heat / 100.0f;
    }

    public float getHeat() {
        return this.heat;
    }

    public float getPistonSpeed() {
        if (CoreProxy.proxy.isSimulating(this.field_70331_k)) {
            return Math.max(0.16f * this.getHeatLevel(), 0.01f);
        }
        switch (this.getEnergyStage()) {
            case BLUE: {
                return 0.02f;
            }
            case GREEN: {
                return 0.04f;
            }
            case YELLOW: {
                return 0.08f;
            }
            case RED: {
                return 0.16f;
            }
        }
        return 0.0f;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (CoreProxy.proxy.isRenderWorld(this.field_70331_k)) {
            if (this.progressPart != 0) {
                this.progress += this.getPistonSpeed();
                if (this.progress > 1.0f) {
                    this.progressPart = 0;
                    this.progress = 0.0f;
                }
            } else if (this.isPumping) {
                this.progressPart = 1;
            }
            return;
        }
        if (this.checkOrienation) {
            this.checkOrienation = false;
            if (!this.isOrientationValid()) {
                this.switchOrientation(true);
            }
        }
        if (!this.isRedstonePowered && this.energy > 1.0f) {
            this.energy -= 1.0f;
        }
        this.updateHeatLevel();
        this.getEnergyStage();
        this.engineUpdate();
        TileEntity tile = this.getTileBuffer(this.orientation).getTile();
        if (this.progressPart != 0) {
            this.progress += this.getPistonSpeed();
            if ((double)this.progress > 0.5 && this.progressPart == 1) {
                this.progressPart = 2;
                this.sendPower();
            } else if (this.progress >= 1.0f) {
                this.progress = 0.0f;
                this.progressPart = 0;
            }
        } else if (this.isRedstonePowered && this.isActive()) {
            if (this.isPoweredTile(tile, this.orientation)) {
                if (this.getPowerToExtract() > 0.0f) {
                    this.progressPart = 1;
                    this.setPumping(true);
                } else {
                    this.setPumping(false);
                }
            } else {
                this.setPumping(false);
            }
        } else {
            this.setPumping(false);
        }
        this.burn();
    }

    private float getPowerToExtract() {
        TileEntity tile = this.getTileBuffer(this.orientation).getTile();
        PowerHandler.PowerReceiver receptor = ((IPowerReceptor)tile).getPowerReceiver(this.orientation.getOpposite());
        return this.extractEnergy(receptor.getMinEnergyReceived(), receptor.getMaxEnergyReceived(), false);
    }

    private void sendPower() {
        TileEntity tile = this.getTileBuffer(this.orientation).getTile();
        if (this.isPoweredTile(tile, this.orientation)) {
            PowerHandler.PowerReceiver receptor = ((IPowerReceptor)tile).getPowerReceiver(this.orientation.getOpposite());
            float extracted = this.getPowerToExtract();
            if (extracted > 0.0f) {
                float needed = receptor.receiveEnergy(PowerHandler.Type.ENGINE, extracted, this.orientation.getOpposite());
                this.extractEnergy(receptor.getMinEnergyReceived(), needed, true);
            }
        }
    }

    protected void burn() {
    }

    protected void engineUpdate() {
        if (!this.isRedstonePowered) {
            if (this.energy >= 1.0f) {
                this.energy -= 1.0f;
            } else if (this.energy < 1.0f) {
                this.energy = 0.0f;
            }
        }
    }

    public boolean isActive() {
        return true;
    }

    protected final void setPumping(boolean isActive) {
        if (this.isPumping == isActive) {
            return;
        }
        this.isPumping = isActive;
        this.sendNetworkUpdate();
    }

    public boolean isOrientationValid() {
        TileEntity tile = this.getTileBuffer(this.orientation).getTile();
        return this.isPoweredTile(tile, this.orientation);
    }

    public boolean switchOrientation(boolean preferPipe) {
        if (preferPipe && this.switchOrientation_do(true)) {
            return true;
        }
        return this.switchOrientation_do(false);
    }

    private boolean switchOrientation_do(boolean pipesOnly) {
        for (int i = this.orientation.ordinal() + 1; i <= this.orientation.ordinal() + 6; ++i) {
            ForgeDirection o = ForgeDirection.VALID_DIRECTIONS[i % 6];
            TileEntity tile = this.getTileBuffer(o).getTile();
            if (pipesOnly && !(tile instanceof IPipeTile) || !this.isPoweredTile(tile, o)) continue;
            this.orientation = o;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
            return true;
        }
        return false;
    }

    public TileBuffer getTileBuffer(ForgeDirection side) {
        if (this.tileCache == null) {
            this.tileCache = TileBuffer.makeBuffer(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, false);
        }
        return this.tileCache[side.ordinal()];
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        this.tileCache = null;
        this.checkOrienation = true;
    }

    public void func_70312_q() {
        super.func_70312_q();
        this.tileCache = null;
        this.checkOrienation = true;
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.orientation = ForgeDirection.getOrientation((int)data.func_74762_e("orientation"));
        this.progress = data.func_74760_g("progress");
        this.energy = data.func_74760_g("energyF");
        NBTBase tag = data.func_74781_a("heat");
        if (tag instanceof NBTTagFloat) {
            this.heat = data.func_74760_g("heat");
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("orientation", this.orientation.ordinal());
        data.func_74776_a("progress", this.progress);
        data.func_74776_a("energyF", this.energy);
        data.func_74776_a("heat", this.heat);
    }

    public void getGUINetworkData(int id, int value) {
        switch (id) {
            case 0: {
                int iEnergy = Math.round(this.energy * 10.0f);
                iEnergy = iEnergy & 0xFFFF0000 | value & 0xFFFF;
                this.energy = iEnergy / 10;
                break;
            }
            case 1: {
                int iEnergy = Math.round(this.energy * 10.0f);
                iEnergy = iEnergy & 0xFFFF | (value & 0xFFFF) << 16;
                this.energy = iEnergy / 10;
                break;
            }
            case 2: {
                this.currentOutput = (float)value / 10.0f;
                break;
            }
            case 3: {
                this.heat = (float)value / 100.0f;
            }
        }
    }

    public void sendGUINetworkData(ContainerEngine containerEngine, ICrafting iCrafting) {
        iCrafting.func_71112_a((Container)containerEngine, 0, Math.round(this.energy * 10.0f) & 0xFFFF);
        iCrafting.func_71112_a((Container)containerEngine, 1, (Math.round(this.energy * 10.0f) & 0xFFFF0000) >> 16);
        iCrafting.func_71112_a((Container)containerEngine, 2, Math.round(this.currentOutput * 10.0f));
        iCrafting.func_71112_a((Container)containerEngine, 3, Math.round(this.heat * 100.0f));
    }

    public abstract boolean isBurning();

    public abstract int getScaledBurnTime(int var1);

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        if (CoreProxy.proxy.isRenderWorld(this.field_70331_k)) {
            return;
        }
        this.addEnergy(this.powerHandler.useEnergy(1.0f, this.maxEnergyReceived(), true) * 0.95f);
    }

    public void addEnergy(float addition) {
        this.energy += addition;
        if (this.getEnergyStage() == EnergyStage.OVERHEAT) {
            this.field_70331_k.func_72876_a(null, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, this.explosionRange(), true);
            this.field_70331_k.func_94571_i(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        if (this.energy > this.getMaxEnergy()) {
            this.energy = this.getMaxEnergy();
        }
    }

    public float extractEnergy(float min, float max, boolean doExtract) {
        float extracted;
        if (this.energy < min) {
            return 0.0f;
        }
        float actualMax = max > this.maxEnergyExtracted() ? this.maxEnergyExtracted() : max;
        if (actualMax < min) {
            return 0.0f;
        }
        if (this.energy >= actualMax) {
            extracted = actualMax;
            if (doExtract) {
                this.energy -= actualMax;
            }
        } else {
            extracted = this.energy;
            if (doExtract) {
                this.energy = 0.0f;
            }
        }
        return extracted;
    }

    public boolean isPoweredTile(TileEntity tile, ForgeDirection side) {
        if (tile instanceof IPowerReceptor) {
            return ((IPowerReceptor)tile).getPowerReceiver(side.getOpposite()) != null;
        }
        return false;
    }

    public abstract float getMaxEnergy();

    public float minEnergyReceived() {
        return 2.0f;
    }

    public abstract float maxEnergyReceived();

    public abstract float maxEnergyExtracted();

    public abstract float explosionRange();

    public float getEnergyStored() {
        return this.energy;
    }

    public abstract float getCurrentOutput();

    @Override
    public LinkedList<ITrigger> getTriggers() {
        LinkedList<ITrigger> triggers = new LinkedList<ITrigger>();
        triggers.add(BuildCraftEnergy.triggerBlueEngineHeat);
        triggers.add(BuildCraftEnergy.triggerGreenEngineHeat);
        triggers.add(BuildCraftEnergy.triggerYellowEngineHeat);
        triggers.add(BuildCraftEnergy.triggerRedEngineHeat);
        return triggers;
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        if (type == IPipeTile.PipeType.POWER) {
            return IPipeConnection.ConnectOverride.DEFAULT;
        }
        if (with == this.orientation) {
            return IPipeConnection.ConnectOverride.DISCONNECT;
        }
        return IPipeConnection.ConnectOverride.DEFAULT;
    }

    @Override
    public boolean canEmitPowerFrom(ForgeDirection side) {
        return side == this.orientation;
    }

    public void checkRedstonePower() {
        this.isRedstonePowered = this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public static enum EnergyStage {
        BLUE,
        GREEN,
        YELLOW,
        RED,
        OVERHEAT;

    }
}

