/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IOverrideDefaultTriggers;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.TriggerParameter;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.network.PacketCoordinates;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketPayloadArrays;
import buildcraft.core.network.PacketPayloadStream;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BCLog;
import buildcraft.transport.Gate;
import buildcraft.transport.Pipe;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeDirection;

public class ContainerGateInterface
extends BuildCraftContainer {
    IInventory playerIInventory;
    Pipe pipe;
    private final NavigableSet<ITrigger> _potentialTriggers = new TreeSet<ITrigger>(new Comparator<ITrigger>(){

        @Override
        public int compare(ITrigger o1, ITrigger o2) {
            return o1.getUniqueTag().compareTo(o2.getUniqueTag());
        }
    });
    private final NavigableSet<IAction> _potentialActions = new TreeSet<IAction>(new Comparator<IAction>(){

        @Override
        public int compare(IAction o1, IAction o2) {
            return o1.getUniqueTag().compareTo(o2.getUniqueTag());
        }
    });
    private boolean isSynchronized = false;
    private boolean isNetInitialized = false;
    public boolean[] triggerState = new boolean[8];
    private int lastTriggerState = 0;

    public ContainerGateInterface(IInventory playerInventory, Pipe pipe) {
        super(0);
        this.playerIInventory = playerInventory;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot(playerInventory, x + y * 9 + 9, 8 + x * 18, pipe.gate.getGuiHeight() - 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot(playerInventory, x, 8 + x * 18, pipe.gate.getGuiHeight() - 26));
        }
        this.pipe = pipe;
        if (!CoreProxy.proxy.isRenderWorld(pipe.container.field_70331_k)) {
            this._potentialActions.addAll(pipe.getActions());
            this._potentialTriggers.addAll(ActionManager.getPipeTriggers(pipe));
            if (pipe.container instanceof IOverrideDefaultTriggers) {
                this._potentialTriggers.addAll(pipe.container.getTriggers());
            }
            for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = pipe.container.getTile(o);
                int blockID = pipe.container.getBlockId(o);
                Block block = Block.field_71973_m[blockID];
                this._potentialTriggers.addAll(ActionManager.getNeighborTriggers(block, tile));
                this._potentialActions.addAll(ActionManager.getNeighborActions(block, tile));
            }
            if (this.getGateOrdinal() < Gate.GateKind.AND_3.ordinal()) {
                Iterator<ITrigger> it = this._potentialTriggers.iterator();
                while (it.hasNext()) {
                    ITrigger trigger = it.next();
                    try {
                        if (!trigger.requiresParameter()) continue;
                        it.remove();
                    }
                    catch (Throwable error) {
                        BCLog.logErrorAPI("Buildcraft", error, trigger.getClass());
                    }
                }
            }
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return true;
    }

    public void markDirty() {
        this.isSynchronized = false;
    }

    public void updateActions(PacketUpdate packet) {
        this._potentialActions.clear();
        PacketPayloadArrays payload = (PacketPayloadArrays)packet.payload;
        int length = payload.intPayload[0];
        for (int i = 0; i < length; ++i) {
            this._potentialActions.add(ActionManager.actions.get(payload.stringPayload[i]));
        }
    }

    public void updateTriggers(PacketUpdate packet) {
        this._potentialTriggers.clear();
        PacketPayloadArrays payload = (PacketPayloadArrays)packet.payload;
        int length = payload.intPayload[0];
        for (int i = 0; i < length; ++i) {
            this._potentialTriggers.add(ActionManager.triggers.get(payload.stringPayload[i]));
        }
    }

    public void setSelection(PacketUpdate packet, boolean notify) {
        try {
            PacketPayloadStream payload = (PacketPayloadStream)packet.payload;
            DataInputStream data = payload.stream;
            int position = data.readInt();
            this.setTrigger(position, ActionManager.triggers.get(data.readUTF()), notify);
            this.setAction(position, ActionManager.actions.get(data.readUTF()), notify);
            ItemStack parameter = Packet.func_73276_c((DataInput)data);
            if (parameter != null) {
                TriggerParameter param = new TriggerParameter();
                param.set(parameter);
                this.setTriggerParameter(position, param, notify);
            } else {
                this.setTriggerParameter(position, null, notify);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private PacketPayload getSelectionPayload(final int position) {
        PacketPayloadStream payload = new PacketPayloadStream(new PacketPayloadStream.StreamWriter(){

            @Override
            public void writeData(DataOutputStream data) throws IOException {
                data.writeInt(position);
                if (ContainerGateInterface.this.pipe.gate.triggers[position] != null) {
                    data.writeUTF(ContainerGateInterface.this.pipe.gate.triggers[position].getUniqueTag());
                } else {
                    data.writeUTF("");
                }
                if (ContainerGateInterface.this.pipe.gate.actions[position] != null) {
                    data.writeUTF(ContainerGateInterface.this.pipe.gate.actions[position].getUniqueTag());
                } else {
                    data.writeUTF("");
                }
                if (ContainerGateInterface.this.pipe.gate.triggerParameters[position] != null && ContainerGateInterface.this.pipe.gate.triggerParameters[position].getItemStack() != null) {
                    Packet.func_73270_a((ItemStack)ContainerGateInterface.this.pipe.gate.triggerParameters[position].getItemStack().func_77946_l(), (DataOutput)data);
                } else {
                    Packet.func_73270_a(null, (DataOutput)data);
                }
            }
        });
        return payload;
    }

    public void sendSelectionChange(int position) {
        CoreProxy.proxy.sendToServer(new PacketUpdate(44, this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n, this.getSelectionPayload(position)).getPacket());
    }

    public void synchronize() {
        if (!this.isNetInitialized && CoreProxy.proxy.isRenderWorld(this.pipe.container.field_70331_k)) {
            this.isNetInitialized = true;
            CoreProxy.proxy.sendToServer(new PacketCoordinates(41, this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n).getPacket());
        }
        if (!this.isSynchronized && CoreProxy.proxy.isRenderWorld(this.pipe.container.field_70331_k)) {
            this.isSynchronized = true;
            CoreProxy.proxy.sendToServer(new PacketCoordinates(42, this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n).getPacket());
        }
    }

    public void func_75137_b(int id, int state) {
        if (id == 0) {
            for (int i = 0; i < 8; ++i) {
                this.triggerState[i] = (state >> i & 1) == 1;
            }
        }
    }

    private int calculateTriggerState() {
        if (this.pipe.gate == null) {
            return 0;
        }
        int state = 0;
        for (int i = 0; i < this.triggerState.length; ++i) {
            if (this.pipe.gate.triggers[i] != null) {
                this.triggerState[i] = this.isNearbyTriggerActive(this.pipe.gate.triggers[i], this.pipe.gate.getTriggerParameter(i));
            }
            state |= this.triggerState[i] ? 1 << i : 0;
        }
        return state;
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        int state = this.calculateTriggerState();
        if (state != this.lastTriggerState) {
            for (int i = 0; i < this.field_75149_d.size(); ++i) {
                ICrafting viewingPlayer = (ICrafting)this.field_75149_d.get(i);
                viewingPlayer.func_71112_a((Container)this, 0, state);
            }
            this.lastTriggerState = state;
        }
    }

    public void handleInitRequest(EntityPlayer player) {
        this.sendActions(player);
        this.sendTriggers(player);
        this.sendSelection(player);
    }

    private void sendActions(EntityPlayer player) {
        int length = this._potentialActions.size();
        PacketPayloadArrays payload = new PacketPayloadArrays(1, 0, length);
        payload.intPayload[0] = length;
        int i = 0;
        for (IAction action : this._potentialActions) {
            payload.stringPayload[i++] = action.getUniqueTag();
        }
        PacketUpdate packet = new PacketUpdate(40, this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n, payload);
        CoreProxy.proxy.sendToPlayer(player, packet);
    }

    private void sendTriggers(EntityPlayer player) {
        int length = this._potentialTriggers.size();
        PacketPayloadArrays payload = new PacketPayloadArrays(1, 0, length);
        payload.intPayload[0] = length;
        int i = 0;
        for (ITrigger trigger : this._potentialTriggers) {
            payload.stringPayload[i++] = trigger.getUniqueTag();
        }
        PacketUpdate packet = new PacketUpdate(45, this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n, payload);
        CoreProxy.proxy.sendToPlayer(player, packet);
    }

    public void sendSelection(EntityPlayer player) {
        if (this.pipe == null || this.pipe.gate == null) {
            return;
        }
        int positions = 0;
        switch (this.pipe.gate.kind) {
            case Single: {
                positions = 1;
                break;
            }
            case AND_2: 
            case OR_2: {
                positions = 2;
                break;
            }
            case AND_3: 
            case OR_3: {
                positions = 4;
                break;
            }
            default: {
                positions = 8;
            }
        }
        for (int position = 0; position < positions; ++position) {
            CoreProxy.proxy.sendToPlayer(player, new PacketUpdate(43, this.pipe.container.field_70329_l, this.pipe.container.field_70330_m, this.pipe.container.field_70327_n, this.getSelectionPayload(position)));
        }
    }

    public boolean hasTriggers() {
        return this._potentialTriggers.size() > 0;
    }

    public ITrigger getFirstTrigger() {
        if (this._potentialTriggers.isEmpty()) {
            return null;
        }
        return (ITrigger)this._potentialTriggers.first();
    }

    public ITrigger getLastTrigger() {
        if (this._potentialTriggers.isEmpty()) {
            return null;
        }
        return (ITrigger)this._potentialTriggers.last();
    }

    public Iterator<ITrigger> getTriggerIterator(boolean descending) {
        return descending ? this._potentialTriggers.descendingIterator() : this._potentialTriggers.iterator();
    }

    public boolean isNearbyTriggerActive(ITrigger trigger, ITriggerParameter parameter) {
        return this.pipe.gate.isNearbyTriggerActive(trigger, parameter);
    }

    public void setTrigger(int position, ITrigger trigger, boolean notify) {
        this.pipe.gate.setTrigger(position, trigger);
        if (CoreProxy.proxy.isRenderWorld(this.pipe.container.field_70331_k) && notify) {
            this.sendSelectionChange(position);
        }
    }

    public void setTriggerParameter(int position, ITriggerParameter parameter, boolean notify) {
        this.pipe.gate.setTriggerParameter(position, parameter);
        if (CoreProxy.proxy.isRenderWorld(this.pipe.container.field_70331_k) && notify) {
            this.sendSelectionChange(position);
        }
    }

    public boolean hasActions() {
        return !this._potentialActions.isEmpty();
    }

    public IAction getFirstAction() {
        if (this._potentialActions.isEmpty()) {
            return null;
        }
        return (IAction)this._potentialActions.first();
    }

    public IAction getLastAction() {
        if (this._potentialActions.isEmpty()) {
            return null;
        }
        return (IAction)this._potentialActions.last();
    }

    public Iterator<IAction> getActionIterator(boolean descending) {
        return descending ? this._potentialActions.descendingIterator() : this._potentialActions.iterator();
    }

    public void setAction(int position, IAction action, boolean notify) {
        this.pipe.gate.setAction(position, action);
        if (CoreProxy.proxy.isRenderWorld(this.pipe.container.field_70331_k) && notify) {
            this.sendSelectionChange(position);
        }
    }

    public ResourceLocation getGateGuiFile() {
        return this.pipe.gate.getGuiFile();
    }

    public final int getGateOrdinal() {
        return this.pipe.gate.kind.ordinal();
    }

    public String getGateName() {
        return this.pipe.gate.getName();
    }
}

