/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.IRetroGenerator;
import mrtjp.projectred.core.PRLogger;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkDataEvent;

public class RetroactiveWorldGenerator
implements ITickHandler {
    public static final RetroactiveWorldGenerator instance = new RetroactiveWorldGenerator();
    String RetroGenID = Configurator.retroGenID;
    String RetroGenNBT = "RetrogenData_";
    private static ArrayList<IRetroGenerator> generators = new ArrayList();
    private static ArrayList<RetroGenQueue> generationQueue = new ArrayList();

    public static void registerRetroGenerator(IRetroGenerator iRetroGenerator) {
        generators.add(iRetroGenerator);
    }

    @ForgeSubscribe
    public void chunkLoad(ChunkDataEvent.Load load2) {
        this.queueRetroactiveGeneration(load2);
    }

    private void queueRetroactiveGeneration(ChunkDataEvent.Load load2) {
        abw abw2 = load2.world;
        RetroDatabase retroDatabase = this.getRetroDatabase(abw2);
        int n = load2.getChunk().g;
        int n2 = load2.getChunk().h;
        for (IRetroGenerator iRetroGenerator : generators) {
            if (!iRetroGenerator.shouldGenerateInLocation(abw2, load2.getChunk()) || !retroDatabase.isGenerationNeeded(n, n2, iRetroGenerator.getSubgenerationID())) continue;
            PRLogger.info("Chunk @(" + n + "," + n2 + ",DIM" + abw2.t.i + ") has been marked for retroactive generation for ID " + iRetroGenerator.getSubgenerationID());
            generationQueue.add(new RetroGenQueue(abw2, n, n2, iRetroGenerator));
            retroDatabase.markChunkRetroGenerated(n, n2, iRetroGenerator.getSubgenerationID());
        }
    }

    private RetroDatabase getRetroDatabase(abw abw2) {
        RetroDatabase retroDatabase = (RetroDatabase)abw2.perWorldStorage.a(RetroDatabase.class, this.RetroGenNBT + this.RetroGenID);
        if (retroDatabase == null) {
            retroDatabase = new RetroDatabase(this.RetroGenNBT + this.RetroGenID);
            abw2.perWorldStorage.a(this.RetroGenNBT + this.RetroGenID, (all)retroDatabase);
            PRLogger.info("Created Retrogen database for dimension " + abw2.t.i);
        }
        return retroDatabase;
    }

    public void tickStart(EnumSet<TickType> enumSet, Object ... objectArray) {
    }

    public void tickEnd(EnumSet<TickType> enumSet, Object ... objectArray) {
        this.runRetroactiveGeneration((abw)((js)objectArray[0]));
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.WORLD);
    }

    public String getLabel() {
        return "pr_retrogen_ticker";
    }

    private void runRetroactiveGeneration(abw abw2) {
        if (generationQueue.size() == 0) {
            return;
        }
        if (abw2.J() % 10L != 0L) {
            return;
        }
        ArrayList<RetroGenQueue> arrayList = new ArrayList<RetroGenQueue>();
        ArrayList arrayList2 = (ArrayList)generationQueue.clone();
        int n = 0;
        for (RetroGenQueue retroGenQueue : arrayList2) {
            retroGenQueue.gen.generate(retroGenQueue.w.s, retroGenQueue.w, retroGenQueue.chunkX, retroGenQueue.chunkZ);
            arrayList.add(retroGenQueue);
            if (++n < 32) continue;
            break;
        }
        generationQueue.removeAll(arrayList);
        PRLogger.info(n + " chunks have been re-generated. " + generationQueue.size() + " left.");
    }

    public static class RetroDatabase
    extends all {
        private HashMap<LocHash, by> chunks = new HashMap();

        public RetroDatabase(String string) {
            super(string);
        }

        public boolean isGenerationNeeded(int n, int n2, String string) {
            by by2 = this.chunks.get(new LocHash(n, n2));
            return by2 == null || !by2.b(string) || !by2.n(string);
        }

        public void markChunkRetroGenerated(int n, int n2, String string) {
            by by2 = this.chunks.get(new LocHash(n, n2));
            if (by2 == null) {
                by2 = new by();
            }
            by2.a(string, true);
            this.chunks.put(new LocHash(n, n2), by2);
            this.c();
        }

        public void a(by by2) {
            int n = by2.e("size");
            for (int i = 0; i < n; ++i) {
                this.chunks.put(new LocHash().readFromNBT(i + "hash", by2), by2.l(i + "tag"));
            }
        }

        public void b(by by2) {
            by2.a("size", this.chunks.size());
            int n = 0;
            for (LocHash locHash : this.chunks.keySet()) {
                locHash.writeToNBT(n + "hash", by2);
                by2.a(n + "tag", (cl)this.chunks.get(locHash));
                ++n;
            }
        }

        private class LocHash {
            int x;
            int z;

            public LocHash() {
            }

            public LocHash(int n, int n2) {
                this.x = n;
                this.z = n2;
            }

            public boolean equals(Object object) {
                if (object instanceof LocHash) {
                    LocHash locHash = (LocHash)object;
                    return locHash.x == this.x && locHash.z == this.z;
                }
                return false;
            }

            public int hashCode() {
                return (this.x ^ this.z) * 31 + 255;
            }

            public LocHash writeToNBT(String string, by by2) {
                by2.a(string + "locx", this.x);
                by2.a(string + "locz", this.z);
                return this;
            }

            public LocHash readFromNBT(String string, by by2) {
                this.x = by2.e(string + "locx");
                this.z = by2.e(string + "locz");
                return this;
            }
        }
    }

    class RetroGenQueue {
        final abw w;
        final int chunkX;
        final int chunkZ;
        final IRetroGenerator gen;

        public RetroGenQueue(abw abw2, int n, int n2, IRetroGenerator iRetroGenerator) {
            this.w = abw2;
            this.chunkX = n;
            this.chunkZ = n2;
            this.gen = iRetroGenerator;
        }
    }
}

