/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.inventory;

import codechicken.core.gui.GuiDraw;
import codechicken.lib.render.FontUtils;
import java.util.ArrayList;
import java.util.List;
import mrtjp.projectred.core.PRColors;
import mrtjp.projectred.core.inventory.GhostWidget;
import mrtjp.projectred.core.utils.ItemKeyStack;
import org.lwjgl.opengl.GL11;

public class WidgetItemSelection
extends GhostWidget {
    int rows;
    int columns;
    int squareSize = 20;
    int currentPage = 0;
    int pagesNeeded = 0;
    boolean waitingForList = true;
    boolean downloadFinished = false;
    private ItemKeyStack selection = null;
    private ItemKeyStack hover = null;
    private int xLast;
    private int yLast;
    private String filter = "";
    public List<ItemKeyStack> displayList = new ArrayList<ItemKeyStack>();
    protected bgw renderItem = new bgw();

    public ItemKeyStack getSelection() {
        return this.selection;
    }

    public WidgetItemSelection(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.rows = n4 / this.squareSize;
        this.columns = n3 / this.squareSize;
    }

    public void setDisplayList(List<ItemKeyStack> list) {
        this.displayList = list;
        this.waitingForList = false;
        this.currentPage = 0;
    }

    public void setNewFilter(String string) {
        this.filter = string;
        this.yLast = -1;
        this.xLast = -1;
        this.currentPage = 0;
    }

    public void pageUp() {
        ++this.currentPage;
        if (this.currentPage > this.pagesNeeded) {
            this.currentPage = this.pagesNeeded;
        }
    }

    public void pageDown() {
        --this.currentPage;
        if (this.currentPage < 0) {
            this.currentPage = 0;
        }
    }

    public void resetDownloadStats() {
        this.waitingForList = true;
        this.downloadFinished = false;
    }

    private boolean filterAllows(ItemKeyStack itemKeyStack) {
        return this.stringsCanSearch(itemKeyStack.key().getName().toLowerCase(), this.filter.toLowerCase());
    }

    private int getSeachedCount() {
        int n = 0;
        for (ItemKeyStack itemKeyStack : this.displayList) {
            if (!this.filterAllows(itemKeyStack)) continue;
            ++n;
        }
        return n;
    }

    private boolean stringsCanSearch(String string, String string2) {
        boolean bl = true;
        for (String string3 : string2.split(" ")) {
            if (string.contains(string3)) continue;
            bl = false;
        }
        return bl;
    }

    private void drawLoadingScreen() {
        int n = this.width() / 2;
        long l = System.currentTimeMillis() / (long)(this.waitingForList ? 40 : 8);
        int n2 = (int)(l % (long)n);
        if (!this.waitingForList && n2 > n - 8) {
            this.downloadFinished = true;
        }
        int n3 = this.x() + this.width() / 2 - n / 2;
        int n4 = this.y() + this.height() / 3;
        FontUtils.drawCenteredString((String)"downloading data", (int)((this.x() + this.width()) / 2), (int)((this.y() + this.height()) / 3 + this.squareSize), (int)-15313551);
        int n5 = n2;
        int n6 = 9;
        avk.a((int)n3, (int)n4, (int)(n3 + n5), (int)(n4 + n6), (int)-15313551);
    }

    private void drawAllItems(int n, int n2) {
        this.hover = null;
        this.selection = null;
        int n3 = this.x() - (this.squareSize - 2);
        int n4 = this.y() + 2;
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        WidgetItemSelection.glItemPre();
        for (ItemKeyStack itemKeyStack : this.displayList) {
            if (!this.filterAllows(itemKeyStack) || ++n7 <= this.rows * this.columns * this.currentPage) continue;
            if (n7 > this.rows * this.columns * (this.currentPage + 1)) break;
            int n8 = n3 + n5 * this.squareSize;
            int n9 = n4 + n6 * this.squareSize;
            if (n > n8 && n < n8 + this.squareSize && n2 > n9 && n2 < n9 + this.squareSize) {
                this.hover = itemKeyStack;
            }
            if (this.xLast > n8 && this.xLast < n8 + this.squareSize && this.yLast > n9 && this.yLast < n9 + this.squareSize) {
                this.selection = itemKeyStack;
            }
            if (this.selection != null && this.selection.equals(itemKeyStack)) {
                WidgetItemSelection.a((int)(n8 - 2), (int)(n9 - 2), (int)(n8 + this.squareSize - 2), (int)(n9 + this.squareSize - 2), (int)-16777216);
                WidgetItemSelection.a((int)(n8 - 1), (int)(n9 - 1), (int)(n8 + this.squareSize - 3), (int)(n9 + this.squareSize - 3), (int)-2960686);
                WidgetItemSelection.a((int)n8, (int)n9, (int)(n8 + this.squareSize - 4), (int)(n9 + this.squareSize - 4), (int)-10921639);
            }
            this.inscribeItemStack(n8, n9, itemKeyStack.makeStack());
            if (++n5 > this.columns) {
                n5 = 1;
                ++n6;
            }
            if (n6 <= this.rows) continue;
            break;
        }
        WidgetItemSelection.glItemPost();
    }

    private void inscribeItemStack(int n, int n2, ye ye2) {
        avi avi2 = ye2.b().getFontRenderer(ye2);
        if (avi2 == null) {
            avi2 = this.fontRenderer();
        }
        this.renderItem.f = 100.0f;
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        this.renderItem.b(avi2, this.renderEngine(), ye2, n, n2);
        this.renderItem.a(avi2, this.renderEngine(), ye2, n, n2, "");
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.renderItem.f = 0.0f;
        String string = ye2.b == 1 ? "" : (ye2.b < 1000 ? ye2.b + "" : (ye2.b < 100000 ? ye2.b / 1000 + "K" : (ye2.b < 1000000 ? "0M" + ye2.b / 100000 : ye2.b / 1000000 + "M")));
        avi2.a(string, n + 19 - 2 - avi2.a(string), n2 + 6 + 3, 0xFFFFFF);
    }

    private static void glItemPre() {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        att.c();
        GL11.glEnable((int)32826);
        bma.a((int)bma.b, (float)240.0f, (float)240.0f);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
    }

    private static void glItemPost() {
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    @Override
    public void drawBack(int n, int n2, float f) {
        this.a(this.x(), this.y(), this.x() + this.width(), this.y() + this.height(), -8355712, -8355712);
        this.pagesNeeded = (this.getSeachedCount() - 1) / (this.rows * this.columns);
        if (this.pagesNeeded < 0) {
            this.pagesNeeded = 0;
        }
        if (this.currentPage > this.pagesNeeded) {
            this.currentPage = this.pagesNeeded;
        }
        if (!this.downloadFinished) {
            this.drawLoadingScreen();
        } else {
            this.drawAllItems(n, n2);
        }
    }

    @Override
    public void drawFront(int n, int n2) {
        if (this.hover != null) {
            GuiDraw.drawMultilineTip((int)(n + 12), (int)(n2 - 12), (List)this.hover.makeStack().a((uf)atv.w().h, atv.w().u.x));
        }
        FontUtils.drawCenteredString((String)("Page: " + (this.currentPage + 1) + "/" + (this.pagesNeeded + 1)), (int)(this.x() + this.width() / 2), (int)(this.y() + this.height() + 6), (int)PRColors.BLACK.rgb);
    }

    @Override
    public void mouseClicked(int n, int n2, int n3) {
        if (this.pointInside(n, n2)) {
            this.xLast = n;
            this.yLast = n2;
        }
    }
}

